# app/controllers/mail_sender_controller.rb のクラス MailSenderController をテストする。

require File.dirname(__FILE__) + '/../test_helper'
require 'mail_sender_controller'

# Re-raise errors caught by the controller.
class MailSenderController; def rescue_action(e) raise e end; end

class MailSenderControllerTest < Test::Unit::TestCase
  def setup
    @controller = MailSenderController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new

    # set logged in
    @request.session[:user_id] = User.find_by_login("tesla")
  end

  POST = [
    [1, :success, "true"]
  ]

  # MailSenderController#post に ID が与えられた場合に
  # 期待される出力が得られることをテストする。
  def test_post
    POST.each do |id, response, body|
      post :post, :id => id
      assert_response response
      assert_equal body, @response.body
    end
  end

  DELIVER = [
    [1, :success, "true"],
  ]

  # MailSenderController#deliver に ID が与えられた場合に
  # 期待される出力が得られることをテストする。
  def test_deliver
    DELIVER.each do |id, response, body|
      post :post, :id => id
      assert_response response
      assert_equal body, @response.body
    end
  end
end
