# -*- coding: utf-8 -*-
require 'test_helper'

class Pick::CalendarControllerTest < ActionController::TestCase
  fixtures :domains, :people, :users

  def setup
    @request.session[:user_id] = User.find_by_login("tesla")
  end

  # rfw パラメータの有無を確認する。
  def test_check_rfw_parameters
    assert_raise(ApplicationController::ClientError) do
      post :search
    end
  end

  def test_search__without_params
    post :search, :rfw => { :return_value => "foo_date" }
    assert_response :success
    assert_template "search"
    assert_select "table.calendar"
  end

  def test_search__year_month
    post :search, :rfw => { :return_value => "foo_date" }, :year => '2009', :month => '01'
    assert_response :success
    assert_template "search"
    assert_select "table.calendar"
    assert_equal 2009, assigns(:year)
    assert_equal 1, assigns(:month)
  end

  def test_search__year_month_next_month
    post :search, :year => '2009', :month => '01', :name => 'next_month', :rfw => { :return_value => "foo_date" }
    assert_response :success
    assert_template "search"
    assert_select "table.calendar"
    assert_equal 2009, assigns(:year)
    assert_equal 2, assigns(:month)
  end

  def test_search__year_month_next_year
    post :search, :year => '2009', :month => '01', :name => 'next_year', :rfw => { :return_value => "foo_date" }
    assert_response :success
    assert_template "search"
    assert_select "table.calendar"
    assert_equal 2010, assigns(:year)
    assert_equal 1, assigns(:month)
  end

  def test_search__year_month_previous_month
    post :search, :year => '2009', :month => '01', :name => 'previous_month', :rfw => { :return_value => "foo_date" }
    assert_response :success
    assert_template "search"
    assert_select "table.calendar"
    assert_equal 2008, assigns(:year)
    assert_equal 12, assigns(:month)
  end

  def test_search__year_month_previous_year
    post :search, :year => '2009', :month => '01', :name => 'previous_year', :rfw => { :return_value => "foo_date" }
    assert_response :success
    assert_template "search"
    assert_select "table.calendar"
    assert_equal 2008, assigns(:year)
    assert_equal 1, assigns(:month)
  end

  def test_search__year_month_previous_year_with_return_format
    post :search, :year => '2009', :month => '01', :name => 'previous_year', :return_format => 'yyyymmdd', :rfw => { :return_value => "foo_date" }
    assert_response :success
    assert_template "search"
    assert_select "table.calendar"
    assert_equal 2008, assigns(:year)
    assert_equal 1, assigns(:month)
    assert_equal 'yyyymmdd', assigns(:return_format)
  end
end
