require 'test_helper'

class AccessLogTest < ActiveSupport::TestCase

  def setup
    @attributes = {
      :uuid          => 'a2d538a0-0885-11de-8c7e-001b63b3ff46',
      :response_time => 0.1,
      :login_id      => 10001,
      :accessed_at   => 'Wed Mar 04 14:35:59 +0900 2009',
      :parameters    => 'params',
      :ip_address    => '192.168.11.15',
    }
  end

  def test_create_accesslog
    assert_difference('AccessLog.count', 1) do
      AccessLog.create @attributes
    end
    assert_raise(ActiveRecord::RecordInvalid) do
      AccessLog.create!
    end
  end

  def test_these_attributes_must_be_needed
    needed_attributes = [
      {:uuid          => 'a2d538a0-0885-11de-8c7e-001b63b3ff46'},
      {:response_time => 0.1},
      {:accessed_at   => 'Wed Mar 04 14:35:59 +0900 2009'},
      {:parameters    => 'params'},
      {:ip_address    => '192.168.11.15'},
    ]
    comb = []
    test_proc = lambda do |a|
      break if a.empty?
      a.each do |e|
        b = a - [e]
        next if comb.include?(b)
        attributes = b.inject(&:merge)
        log = AccessLog.new attributes
        assert !log.valid?
        comb.push(b)
        test_proc.call(b)
      end
    end
    test_proc.call(needed_attributes)
  end

#   def test_valid_ip_address
#     attributes = @attributes.dup
#     attributes.delete(:ip_address)
#     log = AccessLog.new attributes
#     # FIXME: dosen't work when bellow
#     # localhost
#     # example.com
#     %w[
#       192.168.11.15
#       1.1.1.1
#     ].each do |address|
#       log.ip_address = address
#       assert log.valid?
#     end
#   end
# 
#   def test_invalid_ip_address
#     attributes = @attributes.dup
#     attributes.delete(:ip_address)
#     log = AccessLog.new attributes
#     %w[
#       192.168.a.11
#       192.168.11
#       192.11
#       192168111
#       1111.111.111.111
#       .host'
#       host.
#       remote..hoge
#     ].each do |address|
#       log.ip_address = address
#       assert !log.valid?
#     end
#   end

  def test_certainly_create_when_dispatch
    session    = { :user_id => 3 }
    ip_address = { 'REMOTE_ADDR' => '192.168.11.15' }
    parameters = { :controller => 'dummy', :action => 'show' }
    request = mock('request')

    request.stubs(:session => session)
    request.stubs(:env => ip_address)
    request.stubs(:parameters => parameters)

    controller = stub_everything
    controller.stubs(:process).returns(stub_everything)
    controller.stubs(:protected_instance_methods).returns([])
    ActionController::Routing::Routes.stubs(:recognize).returns(controller)
    UUIDHelper.stubs(:uuid).returns('uuuu-id-complication')
    accessed_at = Time.local(2009, 3, 19, 17, 55, 30)
    accessed_at.stubs(:-).returns(1.02)
    Time.stubs(:now).returns(accessed_at)

    dispatcher = ActionController::Dispatcher.new(nil, request)
    assert_difference('AccessLog.count', 1) do
      dispatcher.dispatch
    end
    log = AccessLog.last
    assert_equal 'uuuu-id-complication', log.uuid
    assert_equal 3, log.login_id
    assert_equal accessed_at, log.accessed_at
    assert_equal '192.168.11.15', log.ip_address
    assert_equal 1.02,  log.response_time
    assert_equal YAML.dump(parameters), log.parameters
  end
end
