# -*- coding: utf-8 -*-
# app/models/binary_object.rb のクラス BinaryObject をテストする。

require 'test_helper'

class BinaryObjectTest < ActiveSupport::TestCase
  fixtures :config_attachments, :attachments, :binary_objects

  # BinaryObject#copy() が動作することをテストする。
  def test_copy
    assert BinaryObject.find(1).copy.is_a?(BinaryObject)
  end

  def test_store__filename_error
    bo = BinaryObject.new(:name => "〜" * 1000)
    assert_raise(ConfigAttachment::FilenameMaximumBytesizeError) {bo.store(mock)}
    assert bo.new_record?
  end
end
