# -*- coding: utf-8 -*-
# app/models/permission.rb のクラス Permission をテストする。

require 'test_helper'

class PermissionTest < ActiveSupport::TestCase
  fixtures :permissions, :users

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # Permission.modifiable_conditions が適切な SQL 文(部分)を返すことをテストする。
  def test_modifiable_conditions__admin
    User.current = users(:admin)
    assert_equal "1 = 1", Permission.permissible_conditions(:foo)
  end

  # Permission.modifiable_conditions が適切な SQL 文(部分)を返すことをテストする。
  def test_modifiable_conditions
    User.current = users(:tesla)
    assert Permission.modifiable_conditions(:foo).is_a?(Hash)
  end

  # Permission.permissible_conditions が適切な SQL 文(部分)を返すことをテストする。
  def test_permissible_conditions__admin
    User.current = users(:admin)
    assert_equal "1 = 1", Permission.permissible_conditions(:foo)
  end

  # Permission.permissible_conditions が適切な SQL 文(部分)を返すことをテストする。
  def test_permissible_conditions
    User.current = users(:tesla)
    assert Permission.permissible_conditions(:foo).is_a?(Hash)
  end

  # Permission.invisible_conditions が適切な SQL 文(部分)を返すことをテストする。
  def test_invisible_conditions__admin
    User.current = users(:admin)
    assert_equal "0 = 1", Permission.invisible_conditions(:foo)
  end

  # Permission.invisible_conditions が適切な SQL 文(部分)を返すことをテストする。
  def test_invisible_conditions
    User.current = users(:tesla)
    assert Permission.invisible_conditions(:foo).is_a?(Hash)
  end

  # Permission.create_with_grant_on_and_user_id_and_priority で適切なレコードを作成することをテストする。
  def test_create_with_grant_on_and_user_id_and_priority
    grant_on = mock('grant_on')
    {
      :id        => 1234,
      :domain_id => 1,
      :value     => "full",
      :inception => "20090701",
      :expiry    => "20090831",
      :grant_targettable_id => 100,
      :grant_targettable_type => "Xyz",
    }.each do |k, v|
      grant_on.stubs(k).returns(v)
    end
    permission = Permission.create_with_grant_on_and_user_id_and_priority(grant_on, users(:tesla), 1)
    assert_equal 1234, permission.grant_on_id
    assert_equal 1, permission.domain_id
    assert_equal "full", permission.value
    assert_equal 100, permission.grant_targettable_id
    assert_equal "Xyz", permission.grant_targettable_type
    assert_equal "20090701", permission.inception
    assert_equal "20090831", permission.expiry

    permission = Permission.create_with_grant_on_and_user_id_and_priority(grant_on, users(:tesla), 2, "20090801", "20091231")
    assert_kind_of Permission, permission
    assert_equal "20090801", permission.inception
    assert_equal "20090831", permission.expiry
  end
end
