# -*- coding: utf-8 -*-
# app/models/person.rb のクラス Person をテストする。

require 'test_helper'

class PersonCallbackTest < ActiveSupport::TestCase

  self.use_transactional_fixtures = false

  fixtures(:people, :domains,
           :companies, :company_members,
           :groups, :group_members,
           :organizations, :organization_members,
           :posts, :posted_tos,
           :permissions)

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  def test_after_create_0
    a = Person.new(:domain_id => 1,
                   :name      => "aaa",
                   :default_company_id => 1,
                   :default_organization_id => 1,
                   :default_post_id => 1)
    assert a.save
    assert CompanyMember.exists?(:domain_id => a.domain_id,
                                 :person_id => a.id,
                                 :company_id => a.default_company_id)
    assert OrganizationMember.exists?(:domain_id=> a.domain_id,
                                      :person_id => a.id,
                                      :organization_id => a.default_organization_id)
    assert PostedTo.exists?(:domain_id => a.domain_id,
                            :person_id => a.id,
                            :post_id => a.default_post_id)
  end

  def test_after_create_1
    a = Person.new(:domain_id => 1,
                   :name      => "aaa",
                   :default_company_id => 1,
                   :default_organization_id => nil,
                   :default_post_id => nil)
    assert a.save
    assert CompanyMember.exists?(:domain_id => a.domain_id,
                                 :person_id => a.id,
                                 :company_id => a.default_company_id)
  end

  def test_after_update_0
    a = people(:person_callback)
    original_count = Permission.count(:conditions => { :user_id => users(:person_callback) })
    a.update_attributes(:default_company_id       => 2,
                        :default_organization_id  => 2,
                        :default_post_id          => 2,
                        :keep_original_membership => false)
    assert CompanyMember.exists?(:domain_id => a.domain_id,
                                 :person_id => a.id,
                                 :company_id => a.default_company_id), 'company member'
    assert OrganizationMember.exists?(:domain_id=> a.domain_id,
                                      :person_id => a.id,
                                      :organization_id => a.default_organization_id), 'organization member'
    assert PostedTo.exists?(:domain_id => a.domain_id,
                            :person_id => a.id,
                            :post_id => a.default_post_id), 'posted to'
    assert ! CompanyMember.exists?(:domain_id => a.domain_id,
                                   :person_id => a.id,
                                   :company_id => 1), '! company member'
    assert ! OrganizationMember.exists?(:domain_id=> a.domain_id,
                                        :person_id => a.id,
                                        :organization_id => 1), '! organization member'
    assert ! PostedTo.exists?(:domain_id => a.domain_id,
                              :person_id => a.id,
                              :post_id => 1), '! posted to'
    assert_equal original_count, Permission.count(:conditions => { :user_id => users(:person_callback) })
  end

  def test_after_update_1
    a = people(:person_callback)
    original_count = Permission.count(:conditions => { :user_id => users(:person_callback) })
    a.update_attributes(:default_company_id       => 2,
                        :default_organization_id  => 1,
                        :default_post_id          => 1,
                        :keep_original_membership => false)
    assert CompanyMember.exists?(:domain_id => a.domain_id,
                                 :person_id => a.id,
                                 :company_id => a.default_company_id), 'company member'
    assert OrganizationMember.exists?(:domain_id=> a.domain_id,
                                      :person_id => a.id,
                                      :organization_id => a.default_organization_id), 'organization member'
    assert PostedTo.exists?(:domain_id => a.domain_id,
                            :person_id => a.id,
                            :post_id => a.default_post_id), 'posted to'
    assert ! CompanyMember.exists?(:domain_id => a.domain_id,
                                   :person_id => a.id,
                                   :company_id => 1)
    assert_equal original_count, Permission.count(:conditions => { :user_id => users(:person_callback) })
  end

  def test_after_update_2
    a = people(:person_callback)
    a.update_attributes(:default_company_id       => nil,
                        :default_organization_id  => nil,
                        :default_post_id          => nil,
                        :keep_original_membership => false)
    assert ! CompanyMember.exists?(:domain_id => a.domain_id,
                                   :person_id => a.id,
                                   :company_id => 1)
    assert ! OrganizationMember.exists?(:domain_id=> a.domain_id,
                                        :person_id => a.id,
                                        :organization_id => 1)
    assert ! PostedTo.exists?(:domain_id => a.domain_id,
                              :person_id => a.id,
                              :post_id => 1)
    assert_equal 0, Permission.count(:conditions => { :user_id => users(:person_callback) })
  end

  def test_after_update_3
    a = people(:person_callback)
    a.update_attributes(:default_company_id       => nil,
                        :default_organization_id  => nil,
                        :default_post_id          => nil,
                        :keep_original_membership => true)
    assert CompanyMember.exists?(:domain_id => a.domain_id,
                                 :person_id => a.id,
                                 :company_id => 1)
    assert OrganizationMember.exists?(:domain_id=> a.domain_id,
                                        :person_id => a.id,
                                        :organization_id => 1)
    assert PostedTo.exists?(:domain_id => a.domain_id,
                              :person_id => a.id,
                              :post_id => 1)
    assert_equal 0, Permission.count(:conditions => { :user_id => users(:person_callback) })
  end

  def test_after_update_4
    a = people(:person_callback)
    a.update_attributes(:default_company_id       => 2,
                        :default_organization_id  => nil,
                        :default_post_id          => nil,
                        :keep_original_membership => true)
    assert CompanyMember.exists?(:domain_id => a.domain_id,
                                 :person_id => a.id,
                                 :company_id => 2)
    assert CompanyMember.exists?(:domain_id => a.domain_id,
                                 :person_id => a.id,
                                 :company_id => 1)
    assert OrganizationMember.exists?(:domain_id=> a.domain_id,
                                        :person_id => a.id,
                                        :organization_id => 1)
    assert PostedTo.exists?(:domain_id => a.domain_id,
                              :person_id => a.id,
                              :post_id => 1)
  end
end
