# -*- coding: utf-8 -*-
# app/models/person.rb のクラス Person をテストする。
# コールバックのテスト

require 'test_helper'

class PersonCallbackUpdateTest < ActiveSupport::TestCase
  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # default_company_id を更新した場合適切に Permission が更新されることを確認
  def test_update_default_company_id
    company_a = Company.create!(:domain_id => 1,
                                :code => 'AAA',
                                :name => 'A')
    company_b = Company.create!(:domain_id => 1,
                                :code => 'BBB',
                                :name => 'B')
    grant_on_1 = GrantOn.create!(:domain_id => 1,
                                 :value => 'full',
                                 :inception => '20080101',
                                 :expiry => '20201231',
                                 :grant_targettable_id => 55,
                                 :grant_targettable_type => 'Product',
                                 :roleable_id => company_a.id,
                                 :roleable_type => 'Company')
    grant_on_2 = GrantOn.create!(:domain_id => 1,
                                 :value => 'full',
                                 :inception => '20080101',
                                 :expiry => '20201231',
                                 :grant_targettable_id => 56,
                                 :grant_targettable_type => 'Product',
                                 :roleable_id => company_b.id,
                                 :roleable_type => 'Company')
    person = Person.create!(:domain_id => 1,
                            :name => 'name',
                            :code => 'code',
                            :default_company_id => company_a.id)
    user = User.new(:domain_id => 1,
                    :person_id => person.id,
                    :login => 'loginaaa',
                    :admin => false,
                    :verified => true)
    user.change_password('aaaaa')
    user.save!

    original_permissions = Permission.find(:all,
                                           :conditions => {
                                             :user_id => person.user.id,
                                             :grant_on_id => grant_on_1.id})
    assert_equal(1, original_permissions.size)
    assert_equal(55, original_permissions.first.grant_targettable_id)

    person.reload
    person.update_attribute(:default_company_id, company_b.id)
    assert(!Permission.exists?(:user_id => person.user.id, :grant_on_id => grant_on_1.id))
    permissions = Permission.find(:all,
                                  :conditions => {
                                    :user_id => person.user.id,
                                    :grant_on_id => grant_on_2.id})
    assert_equal(1, permissions.size)
    assert_not_equal(original_permissions.first.id, permissions.first.id)
    assert_equal(56, permissions.first.grant_targettable_id)
  end

end
