# -*- coding: utf-8 -*-
# app/models/po_message_singular.rb のクラス PoMessageSingular をテストする。

require 'test_helper'

class PoMessageSingularTest < ActiveSupport::TestCase
  fixtures :po_messages, :po_arguments, :po_translations

  def test_to_po_string
    assert_equal "msgid \"1|Hello, world!\"\n", po_messages(:one).to_po_string
    assert_equal <<PO_STRING, po_messages(:rfw_100004).to_po_string
msgid "1|rfw|Attachment|Attachments: "
PO_STRING
  end

  def test_to_po_string_global
    assert_equal "msgid \"Hello, world!\"\n", po_messages(:one).to_po_string_global
    assert_equal <<PO_STRING, po_messages(:rfw_100004).to_po_string_global
msgid "rfw|Attachment|Attachments: "
PO_STRING
  end
end
