# -*- coding: utf-8 -*-
# app/models/portlettable_member.rb のクラス PortlettableMember をテストする。

require 'test_helper'

class PortlettableMemberTest < ActiveSupport::TestCase
  fixtures :portlettable_groups, :portlettable_members

  def setup
    CacheEachRequest.clear
    User.current = User.find_by_login("tesla")
  end

  def teardown
    CacheEachRequest.clear
  end

  TITLE = [
    [1, "SubMenu 3 4"],
    [2, "TopMenu 2"],
    [3, "about"],
    [4, "Sample List"],
  ]

  # PortalettableMember#title がタイトルを返すことをテストする。
  def test_title
    TITLE.each do |id, expected|
      assert_equal expected, PortlettableMember.find(id).title
    end
  end

  FIT = [
    [1, "S", true],
    [2, "S", true],
    [3, "S", true],
    [4, "S", true],
    [1, "M", true],
    [2, "M", false],
    [3, "M", false],
    [4, "M", false],
    [1, "L", true],
    [2, "L", false],
    [3, "L", false],
    [4, "L", false],
  ]

  # PortalettableMember#fit? が適切なサイズを判定することをテストする。
  def test_fit?
    FIT.each do |id, s, expected|
      assert_equal expected, PortlettableMember.find(id).fit?(s)
    end
  end
end
