# -*- coding: utf-8 -*-
# lib/simple_pdf.rb のクラス SimplePdf をテストする。

require 'test_helper'

class SimplePDFTest < ActiveSupport::TestCase

  def setup
    @simple_pdf = SimplePDF.new
  end

  def teardown
  end

  # SimplePDF::TextBox が動作することをテストする。
  def test_text_box
    text_box = SimplePDF::TextBox.new("テスト\r\n例")
    assert_equal "テスト\r\n例", text_box.text
    text_box.text = "done"
    assert_equal "done", text_box.text
    assert_equal 10, text_box.font_size
    text_box.font_size = 9
    assert_equal 9, text_box.font_size
  end

  # SimplePDF#Header が動作することをテストする。
  def test_Header
    # already called `Header' in #initialize
    assert !@simple_pdf.instance_variable_get("@header").text.empty?
  end
end
