# -*- coding: utf-8 -*-
# app/models/table_column.rb のクラス TableColumn をテストする。

require 'test_helper'

class TableColumnTest < ActiveSupport::TestCase
  fixtures :application_tables, :table_columns

  def setup
    CacheEachRequest.clear
  end

  def teardown
    CacheEachRequest.clear
  end

  # TableColumn#table が所属するテーブルを返すことをテストする。
  def test_table
    c = table_columns(:matters_anken_code)
    t = c.table
    assert_kind_of ApplicationTable, t
    assert_equal "matters", t.name
  end

  # 各サブクラスのインスタンスメソッド spec が正しい文字列を返すことをテストする。
  def test_spec
    assert_equal "person_id:int:", table_columns(:appointments_person_id).spec
    assert_equal "ymd:string:8", table_columns(:appointments_ymd).spec
    assert_equal "abc:binary", TableColumnBinary.new(:name => "abc").spec
    assert_equal "efg:datetime", TableColumnDatetime.new(:name => "efg").spec
    assert_equal "hij:float", TableColumnFloat.new(:name => "hij").spec
    assert_equal "klm:text", TableColumnText.new(:name => "klm").spec
  end
end
