# -*- coding: utf-8 -*-
# gettext による翻訳モデルに関するモジュール。
module ActiveRecord
  module Acts #:nodoc:
    module Translation #:nodoc:

      # アラビア語の翻訳のモジュール。
      module Ar
        def self.included(base)
          base.extend(ClassMethods)
        end

        module ClassMethods
          def nplurals
            6
          end

          def plural
            "n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n>=3 && n<=10 ? 3 : n>=11 && n<=99 ? 4 : 5"
          end
        end
      end

      # ドイツ語の翻訳のモジュール。
      module De
        def self.included(base)
          base.extend(ClassMethods)
        end
        
        module ClassMethods
          def nplurals
            2
          end

          def plural
            "(n != 1)"
          end
        end
      end

      # 英語の翻訳のモジュール。
      module En
        def self.included(base)
          base.extend(ClassMethods)
        end

        module ClassMethods
          def nplurals
            2
          end

          def plural
            "(n != 1)"
          end
        end
      end

      # スペイン語の翻訳のモジュール。
      module Es
        def self.included(base)
          base.extend(ClassMethods)
        end

        module ClassMethods
          def nplurals
            2
          end

          def plural
            "(n != 1)"
          end
        end
      end

      module Fr
        def self.included(base)
          base.extend(ClassMethods)
        end

        module ClassMethods
          def nplurals
            2
          end

          def plural
            "(n > 1)"
          end
        end
      end

      # 日本語の翻訳のモジュール。
      module Ja
        def self.included(base)
          base.extend(ClassMethods)
        end

        module ClassMethods
          def nplurals
            1
          end

          def plural
            "0"
          end
        end
      end

      # 韓国語の翻訳のモジュール。
      module Ko
        def self.included(base)
          base.extend(ClassMethods)
        end

        module ClassMethods
          def nplurals
            1
          end

          def plural
            "0"
          end
        end
      end

      # ポルトガル語の翻訳のモジュール。
      module Pt
        def self.included(base)
          base.extend(ClassMethods)
        end

        module ClassMethods
          def nplurals
            2
          end

          def plural
            "(n != 1)"
          end
        end
      end

      # ロシア語の翻訳のモジュール。
      module Ru
        def self.included(base)
          base.extend(ClassMethods)
        end

        module ClassMethods
          def nplurals
            3
          end

          def plural
            "(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2)"
          end
        end
      end

      # 中国語の翻訳のモジュール。
      module Zh
        def self.included(base)
          base.extend(ClassMethods)
        end

        module ClassMethods
          def nplurals
            1
          end

          def plural
            "0"
          end
        end
      end

    end
  end
end
