require 'test/unit'
require "format_translator"

class FormatTranslatorTest < Test::Unit::TestCase
  DATE_TEST_DATA = [
    ["2001/02/03", "20010203"],
    ["2001/02", "200102"],
    ["2001/02/03 04:05", "200102030405"],
    ["2001/02/03 04:05:06", "20010203040506"],
  ]
  def test_string_to_display_date
    DATE_TEST_DATA.each do |expected, actual|
      assert_equal expected, actual.to_display_date
    end
  end

  def test_string_to_db_date
    DATE_TEST_DATA.each do |actual, expected|
      assert_equal expected, actual.to_db_date
    end
  end

  COMMIFY_TEST_DATA = [
    ["1", "1"],
    ["21", "21"],
    ["321", "321"],
    ["4,321", "4321"],
    ["54,321", "54321"],
    ["654,321", "654321"],
    ["7,654,321", "7654321"],
    ["87,654,321", "87654321"],
    ["987,654,321", "987654321"],
    ["1,987,654,321", "1987654321"],
    ["9,999,999", "9999999"],
    ["a123b c1,234d 1,987,654,321 $12,345", "a123b c1234d 1987654321 $12345"],
    ["abc,def", "abc,def"],
  ]

  def test_commify
    COMMIFY_TEST_DATA.each do |expected, actual|
      assert_equal expected, actual.commify
    end
  end

  def test_uncommify
    COMMIFY_TEST_DATA.each do |actual, expected|
      assert_equal expected, actual.uncommify
    end
  end

  def test_zip_join
    assert_equal "1000-10#001A", ["1000", "10", "001", "A"].zip_join(["-", "\#", ""])
  end

  def test_zip_insert
    assert_equal "2007年09月11日", "20070911".zip_insert([4,6,8], ["年","月","日"])
  end
end
