/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opengion.fukurou.util.StringUtil;

public class DBEditConfig {
    private static final int EDIT_KEY_NAME = 0;
    private static final int EDIT_KEY_VIEW = 1;
    private static final int EDIT_KEY_SUM = 2;
    private static final int EDIT_KEY_GROUP = 3;
    private static final int EDIT_KEY_SUBTOTAL = 4;
    private static final int EDIT_KEY_TOTAL = 5;
    private static final int EDIT_KEY_GRANDTOTAL = 6;
    private static final int EDIT_KEY_FIRSTTOTAL = 7;
    private static final int EDIT_KEY_ORDERBY = 8;
    private static final int EDIT_KEY_COMMON = 9;
    static final String[] EDIT_KEYS = new String[]{"NAME", "VIEW", "SUM", "GROUP", "SUBTOTAL", "TOTAL", "GRANDTOTAL", "FIRSTTOTAL", "ORDERBY", "COMMON"};
    private static final int EDIT_KEYS_LENGTH = EDIT_KEYS.length;
    private final String[] editVals = new String[EDIT_KEYS_LENGTH];
    private int sumClmCount;
    private int groupClmCount;
    private int subTotalClmCount;
    private int totalClmCount;
    private final Map<String, String> orderMap = new HashMap<String, String>();
    private String orderByDescClms;

    public DBEditConfig() {
    }

    public DBEditConfig(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this.editVals[0] = string;
        this.editVals[1] = string2;
        this.editVals[2] = string3;
        this.editVals[3] = string4;
        this.editVals[4] = string5;
        this.editVals[5] = string6;
        this.editVals[6] = string7;
        this.editVals[7] = string8;
        this.editVals[8] = string9;
        this.editVals[9] = string10;
        this.init();
    }

    public DBEditConfig(String[] stringArray) {
        System.arraycopy(stringArray, 0, this.editVals, 0, stringArray.length);
        this.init();
    }

    private void init() {
        this.sumClmCount = StringUtil.csv2Array((String)this.editVals[2]).length;
        this.groupClmCount = StringUtil.csv2Array((String)this.editVals[3]).length;
        this.subTotalClmCount = StringUtil.csv2Array((String)this.editVals[4]).length;
        this.totalClmCount = StringUtil.csv2Array((String)this.editVals[5]).length;
        if (this.editVals[8] != null) {
            StringBuilder stringBuilder = new StringBuilder(200);
            String[] stringArray = StringUtil.csv2Array((String)this.editVals[8]);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.startsWith("!")) {
                    string = string.substring(1);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string);
                }
                this.orderMap.put(string, String.valueOf(i + 1));
            }
            this.orderByDescClms = stringBuilder.toString();
        } else {
            this.orderByDescClms = null;
        }
    }

    public String[] getEditVals() {
        String[] stringArray = new String[this.editVals.length];
        System.arraycopy(this.editVals, 0, stringArray, 0, this.editVals.length);
        return stringArray;
    }

    public String getEditName() {
        return this.editVals[0];
    }

    public String getViewClms() {
        return this.editVals[1];
    }

    public String getViewClms(String string) {
        String string2 = this.editVals[1];
        if (string == null || string.isEmpty()) {
            return string2;
        }
        String[] stringArray = string2.split(",");
        String[] stringArray2 = string.split(",");
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray2.length; ++i) {
            hashSet.add(stringArray2[i]);
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3 == null || string3.isEmpty()) continue;
            String string4 = string3 = string3.charAt(0) == '!' ? string3.substring(1) : string3;
            if (hashSet.remove(string3)) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(stringArray[i]);
                continue;
            }
            hashSet2.add(string3);
        }
        if (hashSet2.isEmpty() && hashSet.isEmpty()) {
            return string2;
        }
        if (!hashSet.isEmpty()) {
            String[] stringArray3 = hashSet.toArray(new String[hashSet.size()]);
            for (int i = 0; i < stringArray3.length; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('!').append(stringArray3[i]);
            }
        }
        this.editVals[1] = string2 = stringBuilder.toString();
        return string2;
    }

    public String getSumClms() {
        return this.editVals[2];
    }

    public boolean useSum() {
        return this.editVals[2] != null && this.editVals[2].length() > 0;
    }

    public boolean isSumClm(String string) {
        if (string == null || this.editVals[2] == null) {
            return false;
        }
        return ("," + this.editVals[2] + ",").indexOf("," + string + ",") >= 0;
    }

    public int getSumClmCount() {
        return this.sumClmCount;
    }

    public String getGroupClms() {
        return this.editVals[3];
    }

    public boolean useGroup() {
        return this.editVals[3] != null && this.editVals[3].length() > 0;
    }

    public boolean isGroupClm(String string) {
        if (string == null || this.editVals[3] == null) {
            return false;
        }
        return ("," + this.editVals[3] + ",").indexOf("," + string + ",") >= 0;
    }

    public int getGroupClmCount() {
        return this.groupClmCount;
    }

    public String getSubTotalClms() {
        return this.editVals[4];
    }

    public boolean useSubTotal() {
        return this.editVals[4] != null && this.editVals[4].length() > 0;
    }

    public boolean isSubTotalClm(String string) {
        if (string == null || this.editVals[4] == null) {
            return false;
        }
        return ("," + this.editVals[4] + ",").indexOf("," + string + ",") >= 0;
    }

    public int getSubTotalClmCount() {
        return this.subTotalClmCount;
    }

    public String getTotalClms() {
        return this.editVals[5];
    }

    public boolean useTotal() {
        return this.editVals[5] != null && this.editVals[5].length() > 0;
    }

    public boolean isTotalClm(String string) {
        if (string == null || this.editVals[5] == null) {
            return false;
        }
        return ("," + this.editVals[5] + ",").indexOf("," + string + ",") >= 0;
    }

    public int getTotalClmCount() {
        return this.totalClmCount;
    }

    public boolean useGrandTotal() {
        return StringUtil.nval((String)this.editVals[6], (boolean)false);
    }

    public boolean useFirstTotal() {
        return StringUtil.nval((String)this.editVals[7], (boolean)false);
    }

    public String getOrderByClms() {
        return this.editVals[8];
    }

    public String getOrder(String string) {
        if (string == null || this.editVals[8] == null) {
            return "";
        }
        String string2 = this.orderMap.get(string);
        return string2 == null ? "" : string2;
    }

    public boolean isOrderByDesc(String string) {
        if (string == null || this.orderByDescClms == null) {
            return false;
        }
        return ("," + this.orderByDescClms + ",").indexOf("," + string + ",") >= 0;
    }

    public boolean useOrderBy() {
        return this.editVals[8] != null && this.editVals[8].length() > 0;
    }

    public boolean isCommon() {
        return StringUtil.nval((String)this.editVals[9], (boolean)false);
    }
}

