/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.OptionAncestorIF;
import org.opengion.hayabusa.taglib.TransactionTag;

public class QueryOptionTag
extends CommonTagSupport {
    private static final String VERSION = "6.0.4.0 (2014/11/28)";
    private static final long serialVersionUID = 604020141128L;
    private transient DBTableModel table;
    private String selValue;
    private String defaultVal;
    private String dbid;
    private String sql;
    private String separator = " ";
    private boolean quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
    private int classUseNo = -1;
    private int groupUseNo = -1;
    private boolean addKey;
    private int titleUseNo = -1;
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private String rawSql;

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doAfterBody() {
        if (this.table != null) {
            return 0;
        }
        this.useQuotCheck(this.quotCheck);
        this.useXssCheck(this.xssCheck);
        this.sql = this.getBodyString().trim();
        this.rawSql = this.getBodyRawString().trim();
        Query query = QueryFactory.newInstance();
        Object object = null;
        try {
            TransactionTag transactionTag = (TransactionTag)QueryOptionTag.findAncestorWithClass((Tag)this, TransactionTag.class);
            object = transactionTag == null ? new TransactionReal(this.getApplicationInfo()) : transactionTag.getTransaction();
            query.setTransaction(this.dbid, (Transaction)object);
            query.setResourceManager(this.getResource());
            query.setStatement(this.sql);
            query.execute(new String[0]);
            this.table = query.getDBTableModel();
        }
        finally {
            QueryFactory.close(query);
            if (object != null) {
                object.close();
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag()) {
            OptionAncestorIF optionAncestorIF = (OptionAncestorIF)QueryOptionTag.findAncestorWithClass((Tag)this, OptionAncestorIF.class);
            if (optionAncestorIF == null) {
                String string = "<b>" + this.getTagName() + "\u30bf\u30b0\u306f\u3001SelectTag \u307e\u305f\u306f\u3001DatalistTag \u306eBODY \u306b\u8a18\u8ff0\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</b>";
                throw new HybsSystemException(string);
            }
            String string = StringUtil.nval((String)optionAncestorIF.getValue(), (String)this.defaultVal);
            this.selValue = "|" + StringUtil.nval((String)this.selValue, (String)string) + "|";
            this.makeLabel(optionAncestorIF);
            optionAncestorIF.setRawParam(this.rawSql);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.table = null;
        this.selValue = null;
        this.defaultVal = null;
        this.dbid = null;
        this.sql = null;
        this.separator = " ";
        this.classUseNo = -1;
        this.groupUseNo = -1;
        this.quotCheck = HybsSystem.sysBool("USE_SQL_INJECTION_CHECK");
        this.addKey = false;
        this.titleUseNo = -1;
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.rawSql = null;
    }

    protected void setTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
    }

    private void makeLabel(OptionAncestorIF optionAncestorIF) {
        boolean bl = optionAncestorIF.isMultipleAll();
        int n = this.table.getRowCount();
        String string = optionAncestorIF.getAddKeyLabel();
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < n; ++i) {
            Object object;
            if (this.groupUseNo >= 0) {
                object = (String)this.table.getValue(i, this.groupUseNo);
                String string3 = this.getRendererValue(i, this.groupUseNo);
                if (!string2.equals(object)) {
                    if (!"".equals(string2)) {
                        optionAncestorIF.addOption("</optgroup>");
                    }
                    if (!"".equals(object)) {
                        optionAncestorIF.addOption("<optgroup label=\"" + string3 + "\">");
                    }
                    string2 = object;
                }
            }
            object = new Attributes();
            String string4 = (String)this.table.getValue(i, 0);
            object.set("value", string4);
            if (bl || this.selValue.indexOf("|" + string4 + "|") >= 0) {
                object.set("selected", "selected");
            }
            if (this.classUseNo >= 0) {
                object.add("class", (String)this.table.getValue(i, this.classUseNo));
            }
            stringBuilder.setLength(0);
            boolean bl2 = false;
            if (this.table.getColumnCount() == 1) {
                if (this.addKey) {
                    stringBuilder.append(string4).append(':');
                }
                stringBuilder.append(this.getResource().getLabel(string4));
                if (this.titleUseNo >= 0 && !this.getResource().getLabel(string4).equals(this.table.getValue(i, this.titleUseNo))) {
                    bl2 = true;
                }
            } else {
                String string5 = this.getRendererValue(i, 1);
                stringBuilder.append(string5);
                for (int j = 2; j < this.table.getColumnCount(); ++j) {
                    if (j == this.groupUseNo || j == this.classUseNo || j == this.titleUseNo) continue;
                    stringBuilder.append(this.separator);
                    stringBuilder.append(this.getRendererValue(i, j));
                }
                if (this.titleUseNo >= 0 && !string5.equals(this.table.getValue(i, this.titleUseNo))) {
                    bl2 = true;
                }
            }
            if (bl2) {
                object.add("title", (String)this.table.getValue(i, this.titleUseNo));
            }
            object.set("body", stringBuilder.toString());
            optionAncestorIF.addOption(XHTMLTag.option((Attributes)object, (String)string));
        }
        if (this.groupUseNo >= 0 && !"".equals(string2)) {
            optionAncestorIF.addOption("</optgroup>");
        }
    }

    public void setValue(String string) {
        this.selValue = this.getRequestParameter(string);
    }

    public void setDefaultVal(String string) {
        this.defaultVal = this.getRequestParameter(string);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setClassUseNo(String string) {
        this.classUseNo = StringUtil.nval((String)this.getRequestParameter(string), (int)this.classUseNo);
        if (this.classUseNo == 0 || this.classUseNo == 1) {
            throw new HybsSystemException("\u901a\u5e38\u3001\u30ab\u30e9\u30e0\u756a\u53f7=0 \u306f \u30ad\u30fc\u60c5\u5831\u3001=1 \u306f\u30e9\u30d9\u30eb\u60c5\u5831 \u3067\u3059\u30022 \u304b 3 \u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
    }

    public void setGroupUseNo(String string) {
        this.groupUseNo = StringUtil.nval((String)this.getRequestParameter(string), (int)this.groupUseNo);
        if (this.groupUseNo == 0 || this.groupUseNo == 1) {
            throw new HybsSystemException("\u901a\u5e38\u3001\u30ab\u30e9\u30e0\u756a\u53f7=0 \u306f \u30ad\u30fc\u60c5\u5831\u3001=1 \u306f\u30e9\u30d9\u30eb\u60c5\u5831 \u3067\u3059\u30022 \u304b 3 \u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
    }

    public void setQuotCheck(String string) {
        this.quotCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.quotCheck);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setAddKey(String string) {
        this.addKey = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.addKey);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    private String getRendererValue(int n, int n2) {
        String string = (String)this.table.getValue(n, n2);
        DBColumn dBColumn = this.table.getDBColumn(n2);
        return dBColumn.getRendererValue(string);
    }

    public void setTitleUseNo(String string) {
        this.titleUseNo = StringUtil.nval((String)this.getRequestParameter(string), (int)this.titleUseNo);
        if (this.titleUseNo == 0 || this.titleUseNo == 1) {
            throw new HybsSystemException("\u901a\u5e38\u3001\u30ab\u30e9\u30e0\u756a\u53f7=0 \u306f \u30ad\u30fc\u60c5\u5831\u3001=1 \u306f\u30e9\u30d9\u30eb\u60c5\u5831 \u3067\u3059\u30022 \u304b 3 \u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("selValue", (Object)this.selValue).println("defaultVal", (Object)this.defaultVal).println("dbid", (Object)this.dbid).println("sql", (Object)this.sql).println("separator", (Object)this.separator).println("quotCheck", (Object)this.quotCheck).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

