/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class ResponseHeaderTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0.0 (2005/08/31)";
    private static final long serialVersionUID = 400020050831L;
    private String pragma;
    private String cacheControl = "max-age=0";
    private String contentType;
    private int refresh = -1;
    private String refreshURL;
    private String redirect;
    private int status = -1;
    private String location;

    @Override
    public int doEndTag() {
        this.debugPrint();
        int n = 6;
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
        if (this.pragma != null) {
            httpServletResponse.setHeader("Pragma", this.pragma);
        }
        if (this.cacheControl != null) {
            httpServletResponse.setHeader("Cache-Control", this.cacheControl);
        }
        if (this.contentType != null) {
            httpServletResponse.setContentType(this.contentType);
        }
        if (this.refresh >= 0) {
            if (this.refreshURL != null) {
                StringBuilder stringBuilder = new StringBuilder(200).append(this.refresh).append("; URL=").append(httpServletResponse.encodeRedirectURL(this.refreshURL));
                httpServletResponse.setHeader("Refresh", stringBuilder.toString());
            } else {
                httpServletResponse.setIntHeader("Refresh", this.refresh);
            }
            n = 5;
        }
        if (this.redirect != null) {
            try {
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(this.redirect));
            }
            catch (IOException iOException) {
                String string = "sendRedirect \u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CR + " URL=" + this.redirect + CR + iOException.getMessage();
                throw new HybsSystemException(string, iOException);
            }
        }
        if (this.status >= 0) {
            httpServletResponse.setStatus(this.status);
        }
        if (this.location != null) {
            httpServletResponse.setHeader("Location", this.location);
        }
        return n;
    }

    @Override
    protected void release2() {
        super.release2();
        this.pragma = null;
        this.cacheControl = "max-age=0";
        this.contentType = null;
        this.refresh = -1;
        this.refreshURL = null;
        this.redirect = null;
        this.status = -1;
        this.location = null;
    }

    public void setCacheControl(String string) {
        this.cacheControl = StringUtil.nval((String)this.getRequestParameter(string), (String)this.cacheControl);
        if ("no-cache".equals(this.cacheControl)) {
            this.pragma = "no-cache";
        }
    }

    public void setContentType(String string) {
        this.contentType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.contentType);
    }

    public void setRefresh(String string) {
        this.refresh = StringUtil.nval((String)this.getRequestParameter(string), (int)this.refresh);
    }

    public void setRefreshURL(String string) {
        this.refreshURL = StringUtil.nval((String)this.getRequestParameter(string), (String)this.refreshURL);
    }

    public void setRedirect(String string) {
        this.redirect = StringUtil.nval((String)this.getRequestParameter(string), (String)this.redirect);
        if (this.redirect != null && this.redirect.startsWith("\\\\")) {
            this.redirect = "file://" + this.redirect;
        }
    }

    public void setStatus(String string) {
        this.status = StringUtil.nval((String)this.getRequestParameter(string), (int)this.status);
    }

    public void setLocation(String string) {
        this.location = StringUtil.nval((String)this.getRequestParameter(string), (String)this.location);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("pragma", (Object)this.pragma).println("cacheControl", (Object)this.cacheControl).println("contentType", (Object)this.contentType).println("refresh", (Object)this.refresh).println("refreshURL", (Object)this.refreshURL).println("redirect", (Object)this.redirect).println("status", (Object)this.status).println("location", (Object)this.location).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

