/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengion.fukurou.util.StringUtil;

public class ExcelReaderEvent {
    private int nowRowNo = -1;
    private boolean isNowSkip;
    private boolean isNowName;
    private boolean isShtBreak;
    private int skipRowCnt;
    private int clmSize = -1;
    private String[] names;
    private String[] vals;
    private boolean useVals;
    private List<Integer> colList;
    private List<String> nmsList;
    private ConstData cnstData;

    public boolean startSheet(String string, int n) {
        if (this.cnstData != null) {
            this.cnstData.putConstSheet(string);
        }
        return true;
    }

    public void endSheet(int n) {
        this.isShtBreak = false;
        this.endRow(-1);
        if (this.cnstData != null) {
            this.cnstData.clearValsMap();
        }
    }

    public boolean value(String string, int n, int n2) {
        if (string != null && string.length() > 0) {
            int n3;
            if (this.nowRowNo != n) {
                this.endRow(n);
            }
            if (this.cnstData != null) {
                this.cnstData.putConstValue(string, n, n2);
            }
            if (n2 == 0 && string.charAt(0) == '#') {
                if ("#NAME".equalsIgnoreCase(string) && this.clmSize < 0) {
                    this.isNowName = true;
                    this.colList = new ArrayList<Integer>();
                    this.nmsList = new ArrayList<String>();
                }
                this.isNowSkip = !this.isNowName;
            } else if (this.isNowName) {
                this.colList.add(n2);
                this.nmsList.add(string);
            } else if (this.clmSize >= 0 && this.skipRowCnt <= n && (n3 = this.colList.indexOf(n2)) >= 0) {
                this.vals[n3] = string;
                this.useVals = true;
            }
        }
        return !this.isNowSkip;
    }

    public boolean isSkip(int n) {
        return this.isNowSkip && this.nowRowNo == n || this.isShtBreak;
    }

    private void endRow(int n) {
        if (this.isNowName) {
            this.clmSize = this.colList.size();
            this.names = this.nmsList.toArray(new String[this.clmSize]);
            if (this.cnstData != null) {
                this.cnstData.setColumns(this.names);
            }
            this.columnNames((String[])this.names.clone());
            this.isNowName = false;
            this.nmsList = null;
        } else if (this.useVals) {
            if (this.cnstData != null) {
                this.vals = this.cnstData.getConstVals(this.vals);
            }
            this.values(this.vals, this.nowRowNo);
        }
        if (this.clmSize >= 0) {
            this.vals = new String[this.clmSize];
        }
        this.isNowSkip = false;
        this.useVals = false;
        this.nowRowNo = n;
    }

    public void sheetSize(int n) {
    }

    public void columnNames(String ... stringArray) {
    }

    public void values(String[] stringArray, int n) {
    }

    public final void setNames(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            this.colList = new ArrayList<Integer>();
            this.nmsList = new ArrayList<String>();
            String[] stringArray = StringUtil.csv2Array(string);
            int n = bl ? 1 : 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.length() <= 0) continue;
                this.colList.add(i + n);
                this.nmsList.add(string2);
            }
            this.clmSize = this.colList.size();
            this.names = this.nmsList.toArray(new String[this.clmSize]);
            if (this.cnstData != null) {
                this.cnstData.setColumns(this.names);
            }
            this.columnNames((String[])this.names.clone());
            this.nmsList = null;
        }
    }

    public final boolean isNameSet() {
        return this.names != null && this.names.length > 0;
    }

    public void setSheetBreak(boolean bl) {
        this.isShtBreak = bl;
    }

    public void setSkipRowCount(int n) {
        this.skipRowCnt = n;
    }

    public void setSheetConstData(String string, String string2) {
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            return;
        }
        this.cnstData = new ConstData(string, string2);
        if (this.names != null) {
            this.cnstData.setColumns(this.names);
        }
    }

    private static final class ConstData {
        private final Map<String, String> cnstMap = new HashMap<String, String>();
        private final Map<String, Integer> rowcolMap = new HashMap<String, Integer>();
        private final Map<Integer, String> valsMap = new HashMap<Integer, String>();
        private int maxRow = -1;

        ConstData(String string, String string2) {
            String[] stringArray = string.split(",");
            String[] stringArray2 = string2.split(",");
            if (stringArray.length != stringArray2.length) {
                String string3 = "\u30ad\u30fc\u306b\u5bfe\u3059\u308b\u30a2\u30c9\u30ec\u30b9\u306e\u500b\u6570\u304c\u4e0d\u4e00\u81f4\u3067\u3059\u3002Keys=[" + string + "]" + " , Adrs=[" + string2 + "]";
                throw new RuntimeException(string3);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string4;
                String string5 = stringArray[i].trim();
                if (string5 == null || string5.length() <= 0 || (string4 = stringArray2[i].trim()) == null || string4.length() <= 0) continue;
                int n2 = string4.indexOf(45);
                if (n2 > 0) {
                    n = Integer.parseInt(string4.substring(0, n2));
                    if (this.maxRow < n) {
                        this.maxRow = n;
                    }
                } else if ("SHEET".equalsIgnoreCase(string4)) {
                    string4 = "SHEET";
                } else {
                    n = Integer.parseInt(string4.substring(1)) - 1;
                    int n3 = string4.charAt(0) - 65;
                    if (this.maxRow < n) {
                        this.maxRow = n;
                    }
                    string4 = n + "-" + n3;
                }
                this.cnstMap.put(string5, string4);
            }
        }

        void setColumns(String ... stringArray) {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = this.cnstMap.get(stringArray[i]);
                    if (string == null) continue;
                    this.rowcolMap.put(string, i);
                }
            }
        }

        void putConstValue(String string, int n, int n2) {
            String string2;
            Integer n3;
            if (n <= this.maxRow && (n3 = this.rowcolMap.get(string2 = n + "-" + n2)) != null) {
                this.valsMap.put(n3, string);
            }
        }

        void putConstSheet(String string) {
            Integer n = this.rowcolMap.get("SHEET");
            if (n != null) {
                this.valsMap.put(n, string);
            }
        }

        void clearValsMap() {
            this.valsMap.clear();
        }

        String[] getConstVals(String[] stringArray) {
            if (stringArray != null && stringArray.length > 0) {
                for (Map.Entry<Integer, String> entry : this.valsMap.entrySet()) {
                    int n = entry.getKey();
                    String string = entry.getValue();
                    if (n >= stringArray.length) continue;
                    stringArray[n] = string;
                }
            }
            return stringArray;
        }
    }
}

