/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ExcelReaderEvent;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.POIUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class ExcelReader_XSSF {
    private static final String VERSION = "6.1.0.0 (2014/12/26)";
    public static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void excelReader(String string, ExcelReaderEvent excelReaderEvent) {
        OPCPackage oPCPackage = null;
        try {
            oPCPackage = OPCPackage.open((String)string);
            XSSFReader xSSFReader = new XSSFReader(oPCPackage);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(SAX_PARSER);
            List<SheetObj> list = ExcelReader_XSSF.getSheetList(xSSFReader, xMLReader);
            excelReaderEvent.sheetSize(list.size());
            SharedStringsTable sharedStringsTable = xSSFReader.getSharedStringsTable();
            xMLReader.setContentHandler(new SheetHandler(sharedStringsTable, excelReaderEvent));
            InputStream inputStream = null;
            for (int i = 0; i < list.size(); ++i) {
                SheetObj sheetObj = list.get(i);
                if (excelReaderEvent.startSheet(sheetObj.getName(), i)) {
                    try {
                        inputStream = xSSFReader.getSheet(sheetObj.getRid());
                        xMLReader.parse(new InputSource(inputStream));
                    }
                    catch (Throwable throwable) {
                        Closer.ioClose(inputStream);
                        throw throwable;
                    }
                    Closer.ioClose(inputStream);
                }
                excelReaderEvent.endSheet(i);
            }
        }
        catch (OpenXML4JException openXML4JException) {
            String string2 = ".xlsx\u306e\u30d5\u30a1\u30a4\u30eb\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 filename=" + string + HybsConst.CR + openXML4JException.getMessage();
            throw new RuntimeException(string2, openXML4JException);
        }
        catch (SAXException sAXException) {
            String string3 = "SAX \u306e\u4e00\u822c\u7684\u306a\u30a8\u30e9\u30fc\u307e\u305f\u306f\u8b66\u544a\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 filename=" + string + HybsConst.CR + sAXException.getMessage();
            throw new RuntimeException(string3, sAXException);
        }
        catch (IOException iOException) {
            String string4 = ".xlsx\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u53d6\u308a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 filename=" + string + HybsConst.CR + iOException.getMessage();
            throw new RuntimeException(string4, iOException);
        }
        finally {
            if (oPCPackage != null) {
                oPCPackage.revert();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SheetObj> getSheetList(XSSFReader xSSFReader, XMLReader xMLReader) throws SAXException, IOException, InvalidFormatException {
        final ArrayList<SheetObj> arrayList = new ArrayList<SheetObj>();
        xMLReader.setContentHandler(new DefaultHandler(){

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if ("sheet".equals(string3)) {
                    String string4 = attributes.getValue("name");
                    String string5 = attributes.getValue("r:id");
                    arrayList.add(new SheetObj(string4, string5));
                }
            }
        });
        InputStream inputStream = null;
        try {
            inputStream = xSSFReader.getWorkbookData();
            xMLReader.parse(new InputSource(inputStream));
        }
        finally {
            Closer.ioClose(inputStream);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.util.ExcelReader_XSSF \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d");
            return;
        }
        String string = stringArray[0];
        ExcelReader_XSSF.excelReader(string, new ExcelReaderEvent(){

            @Override
            public boolean startSheet(String string, int n) {
                System.out.println("S[" + n + "]=" + string);
                return super.startSheet(string, n);
            }

            @Override
            public boolean value(String string, int n, int n2) {
                System.out.println("R[" + n + "],C[" + n2 + "]=" + string);
                return super.value(string, n, n2);
            }
        });
    }

    private static final class SheetObj {
        private final String name;
        private final String rid;

        public SheetObj(String string, String string2) {
            this.name = string;
            this.rid = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getRid() {
            return this.rid;
        }
    }

    private static final class SheetHandler
    extends DefaultHandler {
        private final SharedStringsTable sst;
        private final ExcelReaderEvent event;
        private String lastContents;
        private boolean isSST;
        private int rowNo = -1;
        private int colNo = -1;
        private boolean isRowSkip;

        private SheetHandler(SharedStringsTable sharedStringsTable, ExcelReaderEvent excelReaderEvent) {
            this.sst = sharedStringsTable;
            this.event = excelReaderEvent;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("row".equals(string3)) {
                this.rowNo = Integer.parseInt(attributes.getValue("r")) - 1;
                this.isRowSkip = false;
            } else {
                if (this.isRowSkip) {
                    return;
                }
                if ("c".equals(string3)) {
                    String string4 = attributes.getValue("r");
                    int[] nArray = POIUtil.kigo2rowCol(string4);
                    this.colNo = nArray[1];
                    this.isSST = "s".equals(attributes.getValue("t"));
                }
            }
            this.lastContents = "";
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.isRowSkip = this.event.isSkip(this.rowNo);
            if (this.isRowSkip) {
                return;
            }
            if ("v".equals(string3)) {
                if (this.isSST) {
                    int n = Integer.parseInt(this.lastContents);
                    this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(n)).toString();
                    this.isSST = false;
                } else if (this.lastContents.endsWith(".0")) {
                    this.lastContents = this.lastContents.substring(0, this.lastContents.length() - 2);
                }
                this.event.value(this.lastContents, this.rowNo, this.colNo);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.isRowSkip) {
                return;
            }
            this.lastContents = this.lastContents + new String(cArray, n, n2);
        }
    }
}

