/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.TreeSet;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.CharacterRun;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Section;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.xmlbeans.XmlException;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ExcelReaderEvent;
import org.opengion.fukurou.util.ExcelReader_HSSF;
import org.opengion.fukurou.util.ExcelReader_XSSF;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.POIEvent;
import org.opengion.fukurou.util.StringUtil;

public final class POIUtil {
    private static final String VERSION = "6.0.3.0 (2014/11/13)";

    private POIUtil() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getText(String string) {
        String string2;
        BufferedInputStream bufferedInputStream = null;
        POITextExtractor pOITextExtractor = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            pOITextExtractor = ExtractorFactory.createExtractor((InputStream)bufferedInputStream);
            string2 = pOITextExtractor.getText();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string3 = "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093[" + string + "]" + HybsConst.CR + fileNotFoundException.getMessage();
                throw new RuntimeException(string3, fileNotFoundException);
                catch (IOException iOException) {
                    String string4 = "\u30d5\u30a1\u30a4\u30eb\u51e6\u7406\u30a8\u30e9\u30fc[" + string + "]" + HybsConst.CR + iOException.getMessage();
                    throw new RuntimeException(string4, iOException);
                }
                catch (InvalidFormatException invalidFormatException) {
                    String string5 = "\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc[" + string + "]" + HybsConst.CR + invalidFormatException.getMessage();
                    throw new RuntimeException(string5, invalidFormatException);
                }
                catch (OpenXML4JException openXML4JException) {
                    String string6 = "ODF-XML\u51e6\u7406\u30a8\u30e9\u30fc[" + string + "]" + HybsConst.CR + openXML4JException.getMessage();
                    throw new RuntimeException(string6, openXML4JException);
                }
                catch (XmlException xmlException) {
                    String string7 = "XML\u51e6\u7406\u30a8\u30e9\u30fc[" + string + "]" + HybsConst.CR + xmlException.getMessage();
                    throw new RuntimeException(string7, xmlException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(pOITextExtractor);
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)pOITextExtractor);
        Closer.ioClose(bufferedInputStream);
        return string2;
    }

    public static void wordReader(String string, POIEvent pOIEvent) {
        BufferedInputStream bufferedInputStream = null;
        StringBuilder stringBuilder = new StringBuilder(200);
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            HWPFDocument hWPFDocument = new HWPFDocument((InputStream)bufferedInputStream);
            Range range = hWPFDocument.getRange();
            int n = 0;
            for (int i = 0; i < range.numSections(); ++i) {
                Section section = range.getSection(i);
                String string2 = null;
                for (int j = 0; j < section.numParagraphs(); ++j) {
                    Paragraph paragraph = section.getParagraph(j);
                    if (paragraph.text().indexOf(12) >= 0) {
                        ++n;
                    }
                    stringBuilder.setLength(0);
                    for (int k = 0; k < paragraph.numCharacterRuns(); ++k) {
                        CharacterRun characterRun = paragraph.getCharacterRun(k);
                        stringBuilder.append(Range.stripFields((String)characterRun.text()));
                    }
                    String string3 = stringBuilder.toString().trim();
                    if (string3.length() <= 0) continue;
                    if (string2 == null) {
                        string2 = string3;
                    }
                    pOIEvent.readText(string3, string2, i, n, j);
                }
            }
        }
        catch (IOException iOException) {
            try {
                String string4 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + string + "]" + HybsConst.CR + iOException.getMessage();
                throw new RuntimeException(string4, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    public static void pptReader(String string, POIEvent pOIEvent) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            SlideShow slideShow = new SlideShow(new HSLFSlideShow((InputStream)bufferedInputStream));
            Slide[] slideArray = slideShow.getSlides();
            for (int i = 0; i < slideArray.length; ++i) {
                String string2 = slideArray[i].getTitle();
                TextRun[] textRunArray = slideArray[i].getTextRuns();
                for (int j = 0; j < textRunArray.length; ++j) {
                    String string3 = textRunArray[j].getText().trim();
                    if (string3.length() <= 0) continue;
                    pOIEvent.readText(string3, string2, i, j);
                }
            }
        }
        catch (IOException iOException) {
            try {
                String string4 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + string + "]" + HybsConst.CR + iOException.getMessage();
                throw new RuntimeException(string4, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    public static void excelReader(String string, ExcelReaderEvent excelReaderEvent) {
        if (string.endsWith(".xls")) {
            ExcelReader_HSSF.excelReader(string, excelReaderEvent);
        } else if (string.endsWith(".xlsx")) {
            ExcelReader_XSSF.excelReader(string, excelReaderEvent);
        } else {
            throw new RuntimeException("\u62e1\u5f35\u5b50\u306f\u3001\u300c.xls\u300d \u304b\u3001\u300c.xlsx\u300d\u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
    }

    public static int[] kigo2rowCol(String string) {
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('A' > c || c > 'Z') {
                n = Integer.parseInt(string.substring(i)) - 1;
                break;
            }
            n2 = (n2 + 1) * 26 + c - 65;
        }
        return new int[]{n, n2};
    }

    public static String getValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        String string = "";
        int n = cell.getCellType();
        switch (n) {
            case 0: {
                string = POIUtil.getNumericTypeString(cell);
                break;
            }
            case 1: {
                RichTextString richTextString = cell.getRichStringCellValue();
                if (richTextString == null) break;
                string = richTextString.getString();
                break;
            }
            case 2: {
                Workbook workbook = cell.getSheet().getWorkbook();
                CreationHelper creationHelper = workbook.getCreationHelper();
                FormulaEvaluator formulaEvaluator = creationHelper.createFormulaEvaluator();
                try {
                    string = POIUtil.getValue(formulaEvaluator.evaluateInCell(cell));
                }
                catch (Throwable throwable) {
                    String string2 = "\u30bb\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002Formula=[" + cell.getCellFormula() + "]" + HybsConst.CR + POIUtil.getCellMsg(cell);
                    System.err.println(string2);
                    System.err.println(StringUtil.ogStackTrace(throwable));
                }
                break;
            }
            case 4: {
                string = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
        }
        return string;
    }

    public static String getNumericTypeString(Cell cell) {
        String string;
        double d = cell.getNumericCellValue();
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            string = HybsDateUtil.getDate(DateUtil.getJavaDate((double)d).getTime(), "yyyyMMddHHmmss");
        } else {
            NumberFormat numberFormat = NumberFormat.getInstance();
            if (numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)numberFormat).applyPattern("#.####");
            }
            string = numberFormat.format(d);
        }
        return string;
    }

    public static void autoCellSize(Workbook workbook, int n, int n2) {
        int n3 = workbook.getNumberOfSheets();
        for (int i = 0; i < n3; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            int n4 = sheet.getDefaultColumnWidth();
            int n5 = n4 * 256 * n;
            int n6 = sheet.getFirstRowNum();
            int n7 = sheet.getLastRowNum();
            Row row = sheet.getRow(n6);
            int n8 = row.getFirstCellNum();
            short s = row.getLastCellNum();
            if (n6 < n2) {
                n6 = n2;
            }
            for (int j = n8; j < s; ++j) {
                double d = SheetUtil.getColumnWidth((Sheet)sheet, (int)j, (boolean)true, (int)n6, (int)n7);
                if (!(d >= 0.0)) continue;
                int n9 = (int)Math.ceil(d * 256.0);
                if (n5 >= 0 && n9 > n5) {
                    n9 = n5;
                }
                sheet.setColumnWidth(j, n9);
            }
        }
    }

    public static void activeWorkbook(Workbook workbook, boolean bl) {
        int n = workbook.getNumberOfSheets();
        block0: for (int i = 0; i < n; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            int n2 = sheet.getFirstRowNum();
            int n3 = sheet.getLastRowNum();
            boolean bl2 = true;
            for (int j = n3; j >= n2 && j >= 0; --j) {
                int n4;
                Row row = sheet.getRow(j);
                if (row == null) continue;
                short s = row.getFirstCellNum();
                for (int k = n4 = row.getLastCellNum(); k >= s && k >= 0; --k) {
                    Cell cell = row.getCell(k);
                    if (cell == null) continue;
                    String string = POIUtil.getValue(cell);
                    if (cell.getCellType() != 3 && string != null && string.length() > 0) {
                        bl2 = false;
                        break;
                    }
                    if (cell.getCellStyle() != null) {
                        bl2 = false;
                        break;
                    }
                    if (!bl) continue;
                    row.removeCell(cell);
                }
                if (bl2) {
                    sheet.removeRow(row);
                    continue;
                }
                if (!bl) continue block0;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Workbook createWorkbook(String string) {
        Workbook workbook;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            workbook = WorkbookFactory.create((InputStream)bufferedInputStream);
        }
        catch (IOException iOException) {
            try {
                String string2 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + string + "]" + HybsConst.CR + iOException.getMessage();
                throw new RuntimeException(string2, iOException);
                catch (InvalidFormatException invalidFormatException) {
                    String string3 = "\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u30a8\u30e9\u30fc[" + string + "]" + HybsConst.CR + invalidFormatException.getMessage();
                    throw new RuntimeException(string3, invalidFormatException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
        return workbook;
    }

    public static String[] getSheetNames(Workbook workbook) {
        int n = workbook.getNumberOfSheets();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            stringArray[i] = sheet.getSheetName();
        }
        return stringArray;
    }

    public static String[] getNames(Workbook workbook) {
        int n = workbook.getNumberOfNames();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < n; ++i) {
            String string = null;
            String string2 = null;
            Name name = workbook.getNameAt(i);
            try {
                string = name.getNameName();
                string2 = name.getRefersToFormula();
            }
            catch (RuntimeException runtimeException) {
                String string3 = "POIUtil:RefersToFormula Error! name=[" + string + "]" + runtimeException.getMessage();
                System.out.println(string3);
            }
            treeSet.add(string + "\t" + string2);
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public static String[] getStyleNames(Workbook workbook) {
        int n = workbook.getNumCellStyles();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < n; ++i) {
            String string;
            CellStyle cellStyle = workbook.getCellStyleAt((short)i);
            if (!(cellStyle instanceof HSSFCellStyle)) continue;
            HSSFCellStyle hSSFCellStyle = (HSSFCellStyle)cellStyle;
            String string2 = hSSFCellStyle.getUserStyleName();
            if (string2 != null) {
                treeSet.add(string2);
                continue;
            }
            HSSFCellStyle hSSFCellStyle2 = hSSFCellStyle.getParentStyle();
            if (hSSFCellStyle2 == null || (string = hSSFCellStyle2.getUserStyleName()) == null) continue;
            treeSet.add(string);
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public static String getCellMsg(Cell cell) {
        String string = null;
        if (cell != null) {
            String string2 = cell.getSheet().getSheetName();
            int n = cell.getRowIndex();
            int n2 = cell.getColumnIndex();
            String string3 = n2 <= 26 ? "" + (char)(65 + n2 % 26) : "" + (char)(65 + n2 / 26 - 1) + (char)(65 + n2 % 26);
            string = " Sheet=" + string2 + ", Row=" + n + ", Cel=" + n2 + "(" + string3 + ") , Val=" + cell.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.util.POIUtil \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d [\u30d1\u30e9\u30e1\u30fc\u30bf]\n\t -A(LL)        \uff65\uff65\uff65 ALL \u4e00\u62ec\u51e6\u7406(\u521d\u671f\u5024)      \n\t -W(ORD)       \uff65\uff65\uff65 Word                      \n\t -P(PT)        \uff65\uff65\uff65 PoworPoint                \n\t -E(XCEL)      \uff65\uff65\uff65 Excel                     \n\t -S(heet)      \uff65\uff65\uff65 Sheet\u540d\u4e00\u89a7               \n\t -N(AME)       \uff65\uff65\uff65 NAME:\u540d\u524d\u5b9a\u7fa9             \n\t -C(ellStyle)  \uff65\uff65\uff65 CellStyle:\u66f8\u5f0f\u306e\u30b9\u30bf\u30a4\u30eb  \n");
            return;
        }
        final String string = stringArray[0];
        int n = stringArray.length == 1 ? 65 : (int)stringArray[1].charAt(1);
        switch (n) {
            case 65: {
                System.out.println(POIUtil.getText(string));
                break;
            }
            case 87: {
                POIUtil.wordReader(string, new POIEvent(){

                    @Override
                    public void readText(String string3, String string2, int ... nArray) {
                        System.out.println("S[" + nArray[0] + "],P[" + string + "],G[" + nArray[2] + "],C[" + string2 + "]=" + string3);
                    }
                });
                break;
            }
            case 80: {
                POIUtil.pptReader(string, new POIEvent(){

                    @Override
                    public void readText(String string3, String string2, int ... nArray) {
                        System.out.println("S[" + nArray[0] + "],T[" + string + "]=" + string3);
                    }
                });
                break;
            }
            case 69: {
                POIUtil.excelReader(string, new ExcelReaderEvent(){

                    @Override
                    public boolean startSheet(String string, int n) {
                        System.out.println("S[" + n + "]=" + string);
                        return super.startSheet(string, n);
                    }

                    @Override
                    public boolean value(String string, int n, int n2) {
                        System.out.println("R[" + n + "],C[" + n2 + "]=" + string);
                        return super.value(string, n, n2);
                    }
                });
                break;
            }
            case 83: {
                String[] stringArray2 = POIUtil.getSheetNames(POIUtil.createWorkbook(string));
                System.out.println("No:\tSheetName");
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println(i + "\t" + stringArray2[i]);
                }
                break;
            }
            case 78: {
                String[] stringArray3 = POIUtil.getNames(POIUtil.createWorkbook(string));
                System.out.println("No:\tName\tFormula");
                for (int i = 0; i < stringArray3.length; ++i) {
                    System.out.println(i + "\t" + stringArray3[i]);
                }
                break;
            }
            case 67: {
                String[] stringArray4 = POIUtil.getStyleNames(POIUtil.createWorkbook(string));
                System.out.println("No:\tStyleName");
                for (int i = 0; i < stringArray4.length; ++i) {
                    System.out.println(i + "\t" + stringArray4[i]);
                }
                break;
            }
            default: {
                System.err.println("Usage: java org.opengion.fukurou.util.POIUtil \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d [\u30d1\u30e9\u30e1\u30fc\u30bf]\n\t -A(LL)        \uff65\uff65\uff65 ALL \u4e00\u62ec\u51e6\u7406(\u521d\u671f\u5024)      \n\t -W(ORD)       \uff65\uff65\uff65 Word                      \n\t -P(PT)        \uff65\uff65\uff65 PoworPoint                \n\t -E(XCEL)      \uff65\uff65\uff65 Excel                     \n\t -S(heet)      \uff65\uff65\uff65 Sheet\u540d\u4e00\u89a7               \n\t -N(AME)       \uff65\uff65\uff65 NAME:\u540d\u524d\u5b9a\u7fa9             \n\t -C(ellStyle)  \uff65\uff65\uff65 CellStyle:\u66f8\u5f0f\u306e\u30b9\u30bf\u30a4\u30eb  \n");
            }
        }
    }
}

