<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX003"
	title	= "対訳"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	<!-- 訳文区分 1:通常ﾗﾍﾞﾙ -->
	select A.SYSTEM_ID, COALESCE(B.LANG,'**') as LANG_YAKU
			, A.CLM as ID,A.LNAME as GENBUN,B.LNAME as YAKU , '1' as KBYAKU
			, CASE WHEN B.LANG is null THEN '0' ELSE '1' END as KBHORYU
	from GEA08 A left outer join GEA08 B
			on  A.SYSTEM_ID = B.SYSTEM_ID
			and A.CLM       = B.CLM
			and A.KBSAKU    = B.KBSAKU
			and A.UNIQ     != B.UNIQ
			and A.LNAME    != B.LNAME
			and B.FGJ       = '1'
			and A.LANG      = 'ja'
			and B.LANG     != 'ja'
	where A.SYSTEM_ID = '{@F_SYSTEM_ID}'
			and A.LNAME     is not null
			and length(A.LNAME) != lengthb(A.LNAME)
			and A.LANG      = 'ja'
			and A.FGJ       = '1'
			and A.KBLBL     &lt;= '9'			<!-- GF の タグリブは省く -->
	union
	<!-- 訳文区分 2:短縮ﾗﾍﾞﾙ -->
	select A.SYSTEM_ID,COALESCE(B.LANG,'**') as LANG_YAKU
			, A.CLM as ID,A.SNAME as GENBUN,B.SNAME as YAKU, '2' as KBYAKU
			, CASE WHEN B.LANG is null THEN '0' ELSE '1' END as KBHORYU
	from GEA08 A left outer join GEA08 B
			on  A.SYSTEM_ID = B.SYSTEM_ID
			and A.CLM       = B.CLM
			and A.KBSAKU    = B.KBSAKU
			and A.UNIQ     != B.UNIQ
			and A.SNAME    != B.SNAME
			and B.FGJ       = '1'
			and A.LANG      = 'ja'
			and B.LANG     != 'ja'
	where A.SYSTEM_ID = '{@F_SYSTEM_ID}'
			and A.SNAME     is not null
			and length( A.SNAME ) != lengthb(A.SNAME )
			and A.LANG      = 'ja'
			and A.FGJ       = '1'
			and A.KBLBL     &lt;= '9'			<!-- GF の タグリブは省く -->
	union
	<!-- 訳文区分 3:概要説明 -->
	select A.SYSTEM_ID,COALESCE(B.LANG,'**') as LANG_YAKU
			, A.CLM as ID,A.DESCRIPTION as GENBUN,B.DESCRIPTION as YAKU, '3' as KBYAKU
			, CASE WHEN B.LANG is null THEN '0' ELSE '1' END as KBHORYU
	from GEA08 A left outer join GEA08 B
			on  A.SYSTEM_ID = B.SYSTEM_ID
			and A.CLM       = B.CLM
			and A.KBSAKU    = B.KBSAKU
			and A.UNIQ     != B.UNIQ
			and A.DESCRIPTION != B.DESCRIPTION
			and B.FGJ       = '1'
			and A.LANG      = 'ja'
			and B.LANG     != 'ja'
	where A.SYSTEM_ID = '{@F_SYSTEM_ID}'
			and A.DESCRIPTION     is not null
			and length( A.DESCRIPTION ) != lengthb(A.DESCRIPTION )
			and A.LANG      = 'ja'
			and A.FGJ       = '1'
			and A.KBLBL     &lt;= '9'			<!-- GF の タグリブは省く -->
</og:query>

<og:entry command="MODIFY" useConsistency="false" selectedAll="true">
	<og:columnSet command="MODIFY" columnId="LANG_YAKU" action="NULLSET" value="**" />
	<og:columnSet command="MODIFY" columnId="SYSTEM_ID" action="SET"     value="{@MEM.SYSTEM_ID}" />
</og:entry>

<!-- すでにDB登録済みのデータがあれば、無視する為に、取得します。 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request" >
	select SYSTEM_ID,LANG_YAKU,ID,GENBUN,YAKU,KBYAKU,KBHORYU
	from   GF28
	where  SYSTEM_ID = '{@MEM.SYSTEM_ID}'
</og:query>

<!-- すでにDB登録済みのデータを除外します。 -->
<og:tableMerge
	action		= "MINUS"
	masterKeys	= "LANG_YAKU,ID,GENBUN"
/>

<!-- リソースは、直接登録します。 -->
<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" selectedAll="true" debug="{@debug}">
	<og:tableUpdateParam
		sqlType  = "INSERT"
		table  = "GF28"
	/>
</og:tableUpdate>

<!-- 変更はここまでです。 -->
<og:forward page="result.jsp" keys="command" vals="RENEW" />

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
