<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX003"
	title	= "対訳"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="NEW" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="NEW" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" debug="{@debug}" maxRowCount="0">
	select case when B.YAKU is not null then '2' else '1' end as WRITABLE ,
			A.SYSTEM_ID,A.KEYWORD,A.GENBUN,A.YAKU AS OLD_YAKU,B.YAKU,B.SYSTEM_ID AS REF_SYSID,
			case when B.YAKU is not null then '1' else A.KBHORYU end as KBHORYU,
			A.LANG_YAKU,A.KBYAKU,A.ID,A.COMMENTS,A.UNIQ,A.FGJ
	from   GF28 A left outer join GF28 B
			on  A.GENBUN    = B.GENBUN
			and A.LANG_YAKU = B.LANG_YAKU
			and B.KBHORYU   = '1'						<!-- KBHORYU='1' は翻訳済み -->
			<og:where startKey="and">
				<og:and value = "B.SYSTEM_ID = '{@REF_SYSID}'" />
			</og:where>
	where  ( A.YAKU is null or A.KBHORYU = '0' )
	and    A.SYSTEM_ID = '{@MEM.SYSTEM_ID}'
	<og:where startKey="and">
		<og:and value = "A.LANG_YAKU = '{@MEM.LANG_YAKU}'" />
	</og:where>
	order by A.SYSTEM_ID,A.GENBUN,A.LANG_YAKU,A.UNIQ
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
	<!-- 登録、取消、リセットボタンを作成します。 -->
	<og:writeCheck>
		<og:submit  action="ENTRY" />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType	= "HTMLFormatTable"
		command			= "NEW"
		columnWritable	= "KBHORYU,YAKU,COMMENTS"
		noDisplay		= "FGJ"
		checked			= "{@checked}"
		startNo			= "{@startNo}" 
		pageSize		= "{@pageSize}"
		rowspan			= "2"
	>
		<tr><td>[KBHORYU]  </td><td>[GENBUN]</td><td>[SYSTEM_ID]</td><td>[ID]     </td><td>[REF_SYSID]</td><td rowspan="2">[COMMENTS]</td></tr>
		<tr><td>[LANG_YAKU]</td><td>[YAKU]  </td><td>[KBYAKU]   </td><td>[KEYWORD]</td><td>[OLD_YAKU]</td></tr>
	</og:view>

	<og:hidden name="sqlType" defaultVal="MODIFY" value="MODIFY" />
</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
