/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;

/**
 * XXXX レンデラーは、パラメータで指定された XXXXフォーマットに対して、
 * 値を変換します。たとえば、郵便番号や、電話番号など、ハイフン編集や、日付や
 * 時刻などの / や : 編集を行います。
 * 例) 1234567     XXX-XXXX       ⇒ 123-4567
 * 例) 1234567890 (XXX)-XXX-XXXX ⇒ (123)-456-7890
 * 例) 20060715     XXXX/XX/XX    ⇒ 2006/07/15
 *
 * XXXX フォーマットよりデータが少ない場合は、以下表示されません。
 * XXXX-XXXX の場合に、データが４桁の場合は、ハイフンは含まれません。
 *
 * フォーマットの初期値はXXXXXXXXXXXXXXXXXXXXです。
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.group データ表示
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_XXXX extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0.0 (2005/08/31)" ;

	private final String form ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 * @og.rev 3.1.1.1 (2003/04/03) 各オブジェクトから自分のインスタンスを返すファクトリメソッドを追加。
	 *
	 */
	public Renderer_XXXX() {
		form   = "XXXXXXXXXXXXXXXXXXXX";
	}

	/**
	 * デフォルトコンストラクター。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Renderer_XXXX( final DBColumn clm ) {
		String tmp = clm.getRendererParam();
		if( tmp == null || tmp.isEmpty() ) { tmp = "XXXXXXXXXXXXXXXXXXXX"; }
		form = tmp ;
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm DBColumnオブジェクト
	 *
	 * @return	CellRendererオブジェクト
	 * @og.rtnNotNull
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return new Renderer_XXXX( clm );
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param	value 入力値
	 *
	 * @return	データの表示用文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final String value ) {
		if( value == null ) { return ""; }

		final char[] formChar = form.toCharArray();
		final char[] valChar  = value.toCharArray();

		final StringBuilder buf = new StringBuilder( BUFFER_MIDDLE );
		int j = 0;
		for( int i=0; i<formChar.length && j<valChar.length; i++ ) {
			if( formChar[i] == 'X' ) {
				buf.append( valChar[j++] );
			}
			else {
				buf.append( formChar[i] );
			}
		}

		return buf.toString();
	}
}
