/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelSorter;
import org.opengion.hayabusa.html.ViewForm;
import org.opengion.hayabusa.html.ViewFormFactory;
import org.opengion.hayabusa.io.JsChartData;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class JsChartTag
extends CommonTagSupport {
    private static final String VERSION = "6.8.3.0 (2017/11/27)";
    private static final long serialVersionUID = 683020171127L;
    public static final String CTYPE_LINE = "line";
    public static final String CTYPE_BAR = "bar";
    public static final String CTYPE_HBAR = "horizontalBar";
    public static final String CTYPE_RADAR = "radar";
    public static final String CTYPE_PA = "polarArea";
    public static final String CTYPE_PIE = "pie";
    public static final String CTYPE_DOUGHNUT = "doughnut";
    private static final Set<String> CTYPE_SET = new ArraySet((Object[])new String[]{"line", "bar", "horizontalBar", "radar", "polarArea", "pie", "doughnut"});
    private static final String[] CTYPE_CI = new String[]{"radar", "polarArea", "pie", "doughnut"};
    private static final Set<String> TYPE_POSITION = new ArraySet((Object[])new String[]{"top", "right", "bottom", "left"});
    private static final Set<String> TYPE_TIMEUNIT = new ArraySet((Object[])new String[]{"year", "quarter", "month", "week", "day", "hour", "minute", "second", "millsecond"});
    private static final Set<String> TYPE_XSCALE = new ArraySet((Object[])new String[]{"category", "time", "linear"});
    private static final Set<String> TYPE_YSCALE = new ArraySet((Object[])new String[]{"linear", "category"});
    private static final Set<String> TYPE_BOOLEAN = new ArraySet((Object[])new String[]{"true", "false"});
    private static final String CANVAS_NAME = "hybscanvas";
    private final List<JsChartData> jsChartData = new ArrayList<JsChartData>();
    private String chartType;
    private String labelColumn;
    private String id;
    private String height = "400";
    private String width = "400";
    private String title;
    private String titlePosition;
    private String xlabel;
    private String ylabel;
    private String legendPosition;
    private String legendDisplay;
    private String xscaleCallback;
    private String yscaleCallback;
    private String xscaleType;
    private String yscaleType;
    private String xmax;
    private String xmin;
    private String xstepSize;
    private String timeUnit;
    private String timeUnitStepSize;
    private String timeSetFormat;
    private String timeLblFormat;
    private String timeMax;
    private String timeMin;
    private String ycategoryList;
    private String max;
    private String min;
    private String stepSize;
    private String barWidthPer = "0.8";
    private String onClick;
    private String tableId = "h_tblmdl";
    private String widthEventColumn;
    private String heightEventColumn;
    private String minEventColumn;
    private String maxEventColumn;
    private boolean useZeroDataOmit;
    private boolean useEqValOmit;
    private boolean useRenderer;
    private String sortColumn;
    private String optionAttributes;

    @Override
    protected void release2() {
        super.release2();
        this.jsChartData.clear();
        this.chartType = null;
        this.id = null;
        this.height = "400";
        this.width = "400";
        this.labelColumn = null;
        this.title = null;
        this.titlePosition = null;
        this.xlabel = null;
        this.ylabel = null;
        this.legendPosition = null;
        this.legendDisplay = null;
        this.xscaleCallback = null;
        this.yscaleCallback = null;
        this.xscaleType = null;
        this.yscaleType = null;
        this.xmax = null;
        this.xmin = null;
        this.xstepSize = null;
        this.timeUnit = null;
        this.timeUnitStepSize = null;
        this.timeSetFormat = null;
        this.timeLblFormat = null;
        this.timeMax = null;
        this.timeMin = null;
        this.ycategoryList = null;
        this.max = null;
        this.min = null;
        this.stepSize = null;
        this.barWidthPer = "0.8";
        this.onClick = null;
        this.tableId = "h_tblmdl";
        this.widthEventColumn = null;
        this.heightEventColumn = null;
        this.maxEventColumn = null;
        this.minEventColumn = null;
        this.useZeroDataOmit = false;
        this.useEqValOmit = false;
        this.useRenderer = false;
        this.sortColumn = null;
        this.optionAttributes = null;
    }

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        this.checkData();
        return 2;
    }

    private void checkData() {
        if ("linear".equals(this.xscaleType) && "category".equals(this.yscaleType)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e\uff7d\uff79\uff70\uff99\uff80\uff72\uff8c\uff9f\u306e\u7d44\u307f\u5408\u308f\u305b\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append("xscaleType:").append(this.xscaleType).append(" yscaleType:").append(this.yscaleType);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        this.id = this.id == null ? CANVAS_NAME + this.tableId : this.id;
        this.jspPrint(this.jsChartOutput());
        return 6;
    }

    private String jsChartOutput() {
        Object object;
        Object object2;
        int n;
        Object object3;
        StringBuilder stringBuilder = new StringBuilder(200);
        String string = "qd_" + this.id;
        String string2 = "cd_" + this.id;
        String string3 = "chart_" + this.id;
        String string4 = this.labelColumn + this.id;
        Object object4 = (DBTableModel)this.getObject(this.tableId);
        if (this.sortColumn != null && !this.sortColumn.isEmpty()) {
            int n2 = object4.getColumnNo(this.sortColumn, false);
            object3 = new DBTableModelSorter();
            ((DBTableModelSorter)object3).setModel((DBTableModel)this.getObject(this.tableId));
            ((DBTableModelSorter)object3).sortByColumn(n2, true);
            object4 = object3;
        }
        ViewForm viewForm = ViewFormFactory.newInstance("JSON");
        viewForm.init((DBTableModel)object4);
        object3 = new ConcurrentHashMap();
        if (this.useZeroDataOmit) {
            Object object5;
            object3.put("h_jsonzeroomt", "true");
            object3.put("h_jsonnullomt", "true");
            n = object4.getColumnCount();
            object2 = new boolean[n];
            for (int i = 0; i < object4.getRowCount(); ++i) {
                object5 = (String[])object4.getValues(i);
                for (int j = 0; j < n; ++j) {
                    Object object6;
                    if (object2[j] || (object6 = object5[j]) == null || ((String)object6).isEmpty() || "0".equals(object6) || "0.0".equals(object6) || "0.00".equals(object6)) continue;
                    object2[j] = true;
                }
            }
            object = this.jsChartData.iterator();
            while (object.hasNext()) {
                object5 = object.next();
                String string5 = ((JsChartData)object5).getChartColumn();
                int n3 = object4.getColumnNo(string5, false);
                if (n3 < 0 || object2[n3]) continue;
                object.remove();
            }
        }
        if (this.useEqValOmit) {
            object3.put("h_jsoneqvalomt", "true");
        }
        if (this.useRenderer) {
            object3.put("h_jsonrnd", "true");
        }
        if (!object3.isEmpty()) {
            viewForm.setParam((ConcurrentMap<String, String>)object3);
        }
        stringBuilder.append("<canvas class=\"").append(CANVAS_NAME).append("\" id=\"").append(this.id).append("\" width=\"").append(this.width).append("\" height=\"").append(this.height).append("\"><!-- --></canvas>");
        stringBuilder.append("<script>").append("var ").append(string).append(" = ").append(viewForm.create());
        for (n = 0; n < this.jsChartData.size(); ++n) {
            stringBuilder.append(" var ").append(this.jsChartData.get(n).getChartColumn()).append(" = [];");
        }
        stringBuilder.append("var ").append(string4).append(" = [];");
        stringBuilder.append("for(var i=0; i < ").append(string).append(".DATA.length; i++){");
        for (n = 0; n < this.jsChartData.size(); ++n) {
            object2 = this.jsChartData.get(n).getChartColumn();
            if ("linear".equals(this.xscaleType)) {
                stringBuilder.append((String)object2).append("[i] = {x:").append(string).append(".DATA[i].").append(this.labelColumn).append(",y:").append(string).append(".DATA[i].").append((String)object2).append("};");
                continue;
            }
            stringBuilder.append((String)object2).append("[i] = ").append(string).append(".DATA[i].").append((String)object2).append(';');
        }
        stringBuilder.append(string4).append("[i] = ").append(string).append(".DATA[i].").append(this.labelColumn).append(';').append('}');
        if ("category".equals(this.yscaleType)) {
            stringBuilder.append("var ycateList = [];");
            if (this.ycategoryList != null && this.ycategoryList.length() > 0) {
                object2 = Pattern.compile(" *, *");
                object = ((Pattern)object2).matcher(this.ycategoryList);
                stringBuilder.append("ycateList = ['").append(((Matcher)object).replaceAll("','")).append("'];");
            }
        }
        stringBuilder.append("var ").append(string2).append(" = {").append("labels:").append(string4);
        if ("category".equals(this.yscaleType)) {
            stringBuilder.append(",yLabels:ycateList");
        }
        stringBuilder.append(",datasets:[");
        for (n = 0; n < this.jsChartData.size(); ++n) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.jsChartData.get(n).getParameter());
        }
        stringBuilder.append("]};");
        stringBuilder.append("var ").append(string3).append(" = new Chart(").append(this.id).append(",{").append("type:'").append(this.chartType).append('\'').append(",data:").append(string2).append(",options:{").append("responsive:false");
        if (this.onClick != null && this.onClick.length() > 0) {
            stringBuilder.append(",onClick:function(event,obj){").append(this.onClick).append('}');
        }
        if (this.title != null && this.title.length() > 0) {
            stringBuilder.append(",title:{").append("display:true");
            this.setProp(stringBuilder, ",text:'", this.title, "'");
            this.setProp(stringBuilder, ",position:'", this.titlePosition, "'");
            stringBuilder.append('}');
        }
        stringBuilder.append(",legend:{");
        this.setProp(stringBuilder, "display:", this.legendDisplay, ",");
        this.setProp(stringBuilder, "position:'", this.legendPosition, "'");
        stringBuilder.append('}');
        List<String> list = Arrays.asList(CTYPE_CI);
        if (list.contains(this.chartType)) {
            stringBuilder.append(",scale: {ticks:{beginAtZero:true");
            this.setProp(stringBuilder, ",max:", this.max);
            this.setProp(stringBuilder, ",min:", this.min);
            this.setProp(stringBuilder, ",stepSize:", this.stepSize);
            stringBuilder.append("}}");
        } else {
            stringBuilder.append(",scales:{");
            if (CTYPE_HBAR.equals(this.chartType)) {
                stringBuilder.append("xAxes");
            } else {
                stringBuilder.append("yAxes");
            }
            stringBuilder.append(":[{");
            this.setProp(stringBuilder, "type:'", this.yscaleType, "',");
            if ("category".equals(this.yscaleType)) {
                stringBuilder.append("position:'left',");
            }
            if (this.ylabel != null && this.ylabel.length() > 0) {
                stringBuilder.append("scaleLabel: {").append("display: true,").append("labelString: '").append(this.ylabel).append('\'').append("},");
            }
            stringBuilder.append("ticks:{beginAtZero:true");
            this.setProp(stringBuilder, ",max:", this.max);
            this.setProp(stringBuilder, ",min:", this.min);
            this.setProp(stringBuilder, ",stepSize:", this.stepSize);
            this.setProp(stringBuilder, ",callback:", this.yscaleCallback);
            stringBuilder.append("}}],");
            if (CTYPE_HBAR.equals(this.chartType)) {
                stringBuilder.append("yAxes");
            } else {
                stringBuilder.append("xAxes");
            }
            stringBuilder.append(":[{");
            this.setProp(stringBuilder, "type:'", this.xscaleType, "',");
            this.setProp(stringBuilder, "categoryPercentage:", this.barWidthPer, ",");
            if ("linear".equals(this.xscaleType)) {
                stringBuilder.append("position:'bottom',");
            }
            if (CTYPE_HBAR.equals(this.chartType)) {
                stringBuilder.append("position:'left',");
            }
            if (this.xlabel != null && this.xlabel.length() > 0) {
                stringBuilder.append("scaleLabel: {").append("display: true,").append("labelString: '").append(this.xlabel).append('\'').append("},");
            }
            stringBuilder.append("time:{");
            this.setProp(stringBuilder, "format:'", this.timeSetFormat, "',");
            if (this.timeLblFormat != null && this.timeLblFormat.length() > 0) {
                stringBuilder.append("displayFormats:{year:'").append(this.timeLblFormat).append("',quarter:'").append(this.timeLblFormat).append("',month:'").append(this.timeLblFormat).append("',week:'").append(this.timeLblFormat).append("',day:'").append(this.timeLblFormat).append("',hour:'").append("',minute:'").append(this.timeLblFormat).append("',second:'").append(this.timeLblFormat).append("',millisecond:'").append("'},");
            }
            this.setProp(stringBuilder, "max:'", this.timeMax, "',");
            this.setProp(stringBuilder, "min:'", this.timeMin, "',");
            this.setProp(stringBuilder, "unit:'", this.timeUnit, "',");
            this.setProp(stringBuilder, "unitStepSize:", this.timeUnitStepSize);
            stringBuilder.append("},");
            stringBuilder.append("ticks:{");
            this.setProp(stringBuilder, "callback:", this.xscaleCallback, ",");
            if ("linear".equals(this.xscaleType)) {
                stringBuilder.append("beginAtZero:true,");
                this.setProp(stringBuilder, "max:", this.xmax, ",");
                this.setProp(stringBuilder, "min:", this.xmin, ",");
                this.setProp(stringBuilder, "stepSize:", this.xstepSize);
            }
            stringBuilder.append("}}]").append('}');
        }
        this.setProp(stringBuilder, ",", this.optionAttributes);
        stringBuilder.append("}});");
        if (this.widthEventColumn != null && this.widthEventColumn.length() > 0) {
            stringBuilder.append("$(document).delegate('#").append(this.widthEventColumn).append("','mouseup',function(){").append("var width = $(this).val();").append("$('#").append(this.id).append("').attr('width',width);").append(string3).append(".chart.width=width;").append(string3).append(".update();").append("} );").append("$(function( ){").append("var chartWidth = $('#").append(this.id).append("').attr('width');").append("$('#").append(this.widthEventColumn).append("').val(chartWidth);").append("});");
        }
        if (this.heightEventColumn != null && this.heightEventColumn.length() > 0) {
            stringBuilder.append("$(document).delegate('#").append(this.heightEventColumn).append("','mouseup',function(){").append("var height = $(this).val();").append("$('#").append(this.id).append("').attr('height',height);").append(string3).append(".chart.height=height;").append(string3).append(".update();").append("} );").append("$(function( ){").append("var chartHeight = $('#").append(this.id).append("').attr('height');").append("$('#").append(this.heightEventColumn).append("').val(chartHeight);").append("});");
        }
        if (this.minEventColumn != null && this.minEventColumn.length() > 0) {
            stringBuilder.append("$(document).delegate('#").append(this.minEventColumn).append("','mouseup',function(){").append("var min = parseInt($(this).val());").append(string3).append(".options.scales.yAxes[0].ticks.min = min;").append(string3).append(".update();").append("} );").append("$(function( ){").append("var chartMax = ").append(string3).append(".scales['y-axis-0'].max;").append("var chartMin = ").append(string3).append(".scales['y-axis-0'].min;").append("$('#").append(this.minEventColumn).append("').val(chartMin);").append("$('#").append(this.minEventColumn).append("').attr({'max':chartMax});").append("$('#").append(this.minEventColumn).append("').attr({'min':chartMin});").append("});");
        }
        if (this.maxEventColumn != null && this.maxEventColumn.length() > 0) {
            stringBuilder.append("$(document).delegate('#").append(this.maxEventColumn).append("','mouseup',function(){").append("var max = parseInt($(this).val());").append(string3).append(".options.scales.yAxes[0].ticks.max = max;").append(string3).append(".update();").append("} );").append("$(function(){").append("var chartMax = ").append(string3).append(".scales['y-axis-0'].max;").append("var chartMin = ").append(string3).append(".scales['y-axis-0'].min;").append("$('#").append(this.maxEventColumn).append("').val(chartMax);").append("$('#").append(this.maxEventColumn).append("').attr({'max':chartMax});").append("$('#").append(this.maxEventColumn).append("').attr({'min':chartMin});").append("});");
        }
        stringBuilder.append("</script>");
        return stringBuilder.toString();
    }

    private void setProp(StringBuilder stringBuilder, String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(string).append(string2);
        }
    }

    private void setProp(StringBuilder stringBuilder, String string, String string2, String string3) {
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(string).append(string2).append(string3);
        }
    }

    private void checkPara(String string, Set<String> set, String string2) {
        if (string != null && string.length() > 0 && !this.check(string, set)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e").append(string2).append("\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append(string2).append("=[").append(string).append("]").append(CR);
            for (String string3 : set) {
                stringBuilder.append(" | ");
                stringBuilder.append(string3);
            }
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setChartType(String string) {
        this.chartType = this.getRequestParameter(string);
        if (this.chartType != null && !this.check(this.chartType, CTYPE_SET)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e\u30c1\u30e3\u30fc\u30c8\u30bf\u30a4\u30d7\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append("chartType=[").append(this.chartType).append("]").append(CR);
            for (String string2 : CTYPE_SET) {
                stringBuilder.append(" | ").append(string2);
            }
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setId(String string) {
        this.id = StringUtil.nval((String)this.getRequestParameter(string), (String)this.id);
    }

    public void setHeight(String string) {
        this.height = StringUtil.nval((String)this.getRequestParameter(string), (String)this.height);
    }

    public void setWidth(String string) {
        this.width = StringUtil.nval((String)this.getRequestParameter(string), (String)this.width);
    }

    public void setLabelColumn(String string) {
        this.labelColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.labelColumn);
    }

    public void setTitle(String string) {
        this.title = this.getRequestParameter(string);
    }

    public void setTitlePosition(String string) {
        this.titlePosition = this.getRequestParameter(string);
        this.checkPara(this.titlePosition, TYPE_POSITION, "titlePosition");
    }

    public void setXlabel(String string) {
        this.xlabel = this.getRequestParameter(string);
    }

    public void setYlabel(String string) {
        this.ylabel = this.getRequestParameter(string);
    }

    public void setLegendPosition(String string) {
        this.legendPosition = this.getRequestParameter(string);
        this.checkPara(this.legendPosition, TYPE_POSITION, "legendPosition");
    }

    public void setLegendDisplay(String string) {
        this.legendDisplay = this.getRequestParameter(string);
        this.checkPara(this.legendDisplay, TYPE_BOOLEAN, "legendDisplay");
    }

    public void setXscaleCallback(String string) {
        this.xscaleCallback = this.getRequestParameter(string);
    }

    public void setYscaleCallback(String string) {
        this.yscaleCallback = this.getRequestParameter(string);
    }

    public void setXscaleType(String string) {
        this.xscaleType = this.getRequestParameter(string);
        this.checkPara(this.xscaleType, TYPE_XSCALE, "xscaleType");
    }

    public void setYscaleType(String string) {
        this.yscaleType = this.getRequestParameter(string);
        this.checkPara(this.yscaleType, TYPE_YSCALE, "yscaleType");
    }

    public void setYcategoryList(String string) {
        this.ycategoryList = this.getRequestParameter(string);
    }

    public void setXmax(String string) {
        this.xmax = this.getRequestParameter(string);
    }

    public void setXmin(String string) {
        this.xmin = this.getRequestParameter(string);
    }

    public void setXstepSize(String string) {
        this.xstepSize = this.getRequestParameter(string);
    }

    public void setBarWidthPer(String string) {
        this.barWidthPer = this.getRequestParameter(string);
    }

    protected void addJsChartData(JsChartData jsChartData) {
        this.jsChartData.add(jsChartData);
    }

    protected int getJsChartDataSize() {
        return this.jsChartData.size();
    }

    public void setTimeUnit(String string) {
        this.timeUnit = this.getRequestParameter(string);
        this.checkPara(this.timeUnit, TYPE_TIMEUNIT, "timeUnit");
    }

    public void setTimeUnitStepSize(String string) {
        this.timeUnitStepSize = this.getRequestParameter(string);
    }

    public void setTimeSetFormat(String string) {
        this.timeSetFormat = this.getRequestParameter(string);
    }

    public void setTimeLblFormat(String string) {
        this.timeLblFormat = this.getRequestParameter(string);
    }

    public void setTimeMax(String string) {
        this.timeMax = this.getRequestParameter(string);
    }

    public void setTimeMin(String string) {
        this.timeMin = this.getRequestParameter(string);
    }

    public void setMax(String string) {
        this.max = StringUtil.nval((String)this.getRequestParameter(string), (String)this.max);
    }

    public void setMin(String string) {
        this.min = StringUtil.nval((String)this.getRequestParameter(string), (String)this.min);
    }

    public void setStepSize(String string) {
        this.stepSize = StringUtil.nval((String)this.getRequestParameter(string), (String)this.stepSize);
    }

    public void setOnClick(String string) {
        this.onClick = StringUtil.nval((String)this.getRequestParameter(string), (String)this.onClick);
    }

    public void setTableId(String string) {
        this.tableId = this.getRequestParameter(string);
    }

    public void setWidthEventColumn(String string) {
        this.widthEventColumn = this.getRequestParameter(string);
    }

    public void setHeightEventColumn(String string) {
        this.heightEventColumn = this.getRequestParameter(string);
    }

    public void setMinEventColumn(String string) {
        this.minEventColumn = this.getRequestParameter(string);
    }

    public void setMaxEventColumn(String string) {
        this.maxEventColumn = this.getRequestParameter(string);
    }

    public void setUseZeroDataOmit(String string) {
        this.useZeroDataOmit = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useZeroDataOmit);
    }

    public void setUseEqValOmit(String string) {
        this.useEqValOmit = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useEqValOmit);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    public void setSortColumn(String string) {
        this.sortColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sortColumn);
    }

    public void setOptionAttributes(String string) {
        this.optionAttributes = StringUtil.nval((String)this.getRequestParameter(string), (String)this.optionAttributes);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("id", (Object)this.id).println("tableId", (Object)this.tableId).println("chartType", (Object)this.chartType).println("width", (Object)this.width).println("height", (Object)this.height).println("max", (Object)this.max).println("min", (Object)this.min).println("stepSize", (Object)this.stepSize).println("barWidthPer", (Object)this.barWidthPer).println("timeUnit", (Object)this.timeUnit).println("timeUnitStepSize", (Object)this.timeUnitStepSize).println("timeLblFormat", (Object)this.timeLblFormat).println("timeSetFormat", (Object)this.timeSetFormat).println("timeMax", (Object)this.timeMax).println("timeMin", (Object)this.timeMin).println("title", (Object)this.title).println("titlePosition", (Object)this.titlePosition).println("xlabel", (Object)this.xlabel).println("ylabel", (Object)this.ylabel).println("legendPosition", (Object)this.legendPosition).println("legendDisplay", (Object)this.legendDisplay).println("yscaleCallback", (Object)this.yscaleCallback).println("xscaleCallback", (Object)this.xscaleCallback).println("xscaleType", (Object)this.xscaleType).println("xmax", (Object)this.xmax).println("xmin", (Object)this.xmin).println("xstepSize", (Object)this.xstepSize).println("yscaleType", (Object)this.yscaleType).println("ycategoryList", (Object)this.ycategoryList).println("widthEventColumn", (Object)this.widthEventColumn).println("heightEventColumn", (Object)this.heightEventColumn).println("minEventColumn", (Object)this.minEventColumn).println("maxEventColumn", (Object)this.maxEventColumn).println("optionAttributes", (Object)this.optionAttributes).fixForm().toString();
    }
}

