/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.opengion.fukurou.util.StringUtil;

public final class TagBuffer {
    private static final Set<String> YOSO_SET = new HashSet<String>(Arrays.asList("area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"));
    private final StringBuilder tagBuf = new StringBuilder(200);
    private final StringBuilder bodyBuf = new StringBuilder(200);
    private final StringBuilder makeBuf = new StringBuilder(200);
    private DTYPE dType = DTYPE.TAG;
    private String name;
    private char kvsep;
    private String endStr;
    private String cacheTag;
    private boolean isKaraTag;

    public TagBuffer() {
    }

    public TagBuffer(String string) {
        this.startTag(string);
    }

    public TagBuffer startTag(String string) {
        return this.start(DTYPE.TAG, string, '=', " ");
    }

    public TagBuffer startCss(String string) {
        return this.start(DTYPE.CSS, string, ':', "; ");
    }

    public TagBuffer startJson() {
        return this.start(DTYPE.JSON, null, ':', ", ");
    }

    public TagBuffer startArray() {
        return this.start(DTYPE.ARY, null, ' ', ", ");
    }

    private TagBuffer start(DTYPE dTYPE, String string, char c, String string2) {
        this.dType = dTYPE;
        this.name = string;
        this.kvsep = c;
        this.endStr = string2;
        this.isKaraTag = string != null && YOSO_SET.contains(string.toLowerCase(Locale.JAPAN));
        return this;
    }

    public TagBuffer addBuffer(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!StringUtil.isNotNull(string)) continue;
                this.makeBuf.append(string).append(' ');
            }
        }
        return this;
    }

    public TagBuffer addBuffer(String string, boolean bl) {
        return bl ? this.addBuffer(string) : this;
    }

    public TagBuffer add(String string) {
        return this.addOptions(string);
    }

    public TagBuffer addOptions(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!StringUtil.isNotNull(string)) continue;
                this.tagBuf.append(string).append(' ');
            }
        }
        return this;
    }

    public TagBuffer addOptions(String string, boolean bl) {
        return bl ? this.addOptions(string) : this;
    }

    public TagBuffer addBody(String ... stringArray) {
        if (this.dType == DTYPE.TAG && stringArray != null) {
            this.bodyBuf.append(String.join((CharSequence)" ", stringArray));
        }
        return this;
    }

    public TagBuffer addBody(String string, boolean bl) {
        return bl ? this.addBody(string) : this;
    }

    public TagBuffer addNum(String ... stringArray) {
        if (this.dType == DTYPE.ARY && stringArray != null) {
            for (String string : stringArray) {
                if (string == null) {
                    this.tagBuf.append(this.endStr);
                    continue;
                }
                this.tagBuf.append(string).append(this.endStr);
            }
        }
        return this;
    }

    public TagBuffer addNum(String string, boolean bl) {
        return bl ? this.addNum(string) : this;
    }

    public TagBuffer addStr(String ... stringArray) {
        if (this.dType == DTYPE.ARY && stringArray != null) {
            for (String string : stringArray) {
                if (string == null) {
                    this.tagBuf.append("\"\"").append(this.endStr);
                    continue;
                }
                this.tagBuf.append('\"').append(string).append('\"').append(this.endStr);
            }
        }
        return this;
    }

    public TagBuffer addStr(String string, boolean bl) {
        return bl ? this.addStr(string) : this;
    }

    public TagBuffer add(String string, String string2) {
        return this.add(string, string2, true);
    }

    public TagBuffer add(String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null && stringArray.length == stringArray2.length) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(stringArray[i], stringArray2[i], true);
            }
        }
        return this;
    }

    public TagBuffer add(String string, String string2, boolean bl) {
        if (bl && this.dType != DTYPE.ARY && StringUtil.isNotNull(string) && string2 != null) {
            if (this.dType == DTYPE.JSON) {
                this.tagBuf.append('\"').append(string).append('\"').append(this.kvsep);
            } else {
                this.tagBuf.append(string).append(this.kvsep);
            }
            if (this.dType == DTYPE.CSS) {
                this.tagBuf.append(string2);
            } else if (string2.indexOf(34) >= 0) {
                this.tagBuf.append('\'').append(string2.indexOf(39) >= 0 ? string2.replaceAll("'", "&#39;") : string2).append('\'');
            } else {
                this.tagBuf.append('\"').append(string2).append('\"');
            }
            this.tagBuf.append(this.endStr);
        }
        return this;
    }

    public TagBuffer make() {
        if (this.dType == DTYPE.TAG) {
            if (this.name == null) {
                this.makeBuf.append((CharSequence)this.tagBuf);
            } else {
                this.makeBuf.append('<').append(this.name).append(' ').append((CharSequence)this.tagBuf);
                if (this.isKaraTag) {
                    this.makeBuf.append(">");
                } else {
                    this.makeBuf.append('>').append((CharSequence)this.bodyBuf).append("</").append(this.name).append('>');
                }
            }
        } else if (this.dType == DTYPE.CSS) {
            if (this.name == null) {
                this.makeBuf.append((CharSequence)this.tagBuf);
            } else {
                this.makeBuf.append(this.name).append(" { ").append((CharSequence)this.tagBuf).append(" } ");
            }
        } else if (this.dType == DTYPE.JSON) {
            this.makeBuf.append(" { ").append((CharSequence)this.tagBuf).append(" }, ");
        } else if (this.dType == DTYPE.ARY) {
            this.makeBuf.append(" [ ").append((CharSequence)this.tagBuf).append(" ], ");
        }
        this.tagBuf.setLength(0);
        this.bodyBuf.setLength(0);
        return this;
    }

    public String toBefore() {
        String string = this.dType == DTYPE.TAG && this.name != null ? new StringBuilder(200).append('<').append(this.name).append(' ').append((CharSequence)this.tagBuf).append('>').toString() : this.tagBuf.toString();
        return string;
    }

    public TagBuffer clear() {
        this.tagBuf.setLength(0);
        this.bodyBuf.setLength(0);
        this.makeBuf.setLength(0);
        return this;
    }

    public String toString() {
        return this.makeBuf.toString();
    }

    public String makeTag() {
        if (this.cacheTag == null) {
            this.cacheTag = this.make().toString();
        }
        return this.cacheTag;
    }

    public String makeTag(int n, String string) {
        if (this.cacheTag == null) {
            this.cacheTag = this.make().toString();
        }
        return this.cacheTag.replace("[I]", String.valueOf(n)).replace("[V]", string);
    }

    private static enum DTYPE {
        TAG,
        CSS,
        JSON,
        ARY;

    }
}

