/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.EDbid;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.xml.DomParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseConfig {
    private static final String DEFAULT_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String DB_CONFIG_FILE = "../DBConfig.xml";
    private final String xmlFilename;
    private final Map<String, EDbid> dbidMap = Collections.synchronizedMap(new LinkedHashMap());
    private final List<String> driverList = Collections.synchronizedList(new ArrayList());
    private String codeKeyVal;
    private static final String[] DBID_INFO_KEYS = new String[]{"dbidKey", "title", "url", "user", "password", "readonly", "mincount", "maxcount", "pooltime", "applicationInfo", "property"};
    private static final String DBDRIVER_CLASS_KEY = "class";

    public DatabaseConfig() {
        this(DB_CONFIG_FILE);
    }

    public DatabaseConfig(String string) {
        Object object;
        String string2 = string == null || string.isEmpty() ? DB_CONFIG_FILE : string;
        String string3 = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource(string2);
        if (uRL == null) {
            uRL = classLoader.getResource("/");
            if (uRL != null && ((File)(object = new File(uRL.getPath(), string2))).exists()) {
                string3 = ((File)object).getAbsolutePath();
            }
        } else {
            string3 = uRL.getFile().replaceAll("%23%23", "##");
            if (!new File(string3).exists()) {
                string3 = null;
            }
        }
        if (string3 == null && new File(string2).exists()) {
            string3 = string2;
        }
        if (string3 == null) {
            object = "DBConfig.xml\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002File=[" + string2 + "]\n WEB-INF/classes \u30d5\u30a9\u30eb\u30c0\u304c\u306a\u3044\u3068\u3001\u76f8\u5bfe\u30d1\u30b9\u3067\u898b\u3064\u3051\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new OgRuntimeException((String)object);
        }
        this.xmlFilename = string3;
        this.init();
    }

    public EDbid getDbid(String string) {
        return this.dbidMap.get(string.toUpperCase(Locale.JAPAN));
    }

    public void reload() {
        this.dbidMap.clear();
        this.driverList.clear();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Document document = DomParser.read(new File(this.xmlFilename));
        Element element = document.getDocumentElement();
        this.makeDriverList(element);
        Object object = this;
        synchronized (object) {
            for (String string : this.driverList) {
                try {
                    Class.forName(string);
                }
                catch (Throwable throwable) {
                    String string2 = "\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + string + "]";
                    LogWriter.log(string2);
                    LogWriter.log(throwable);
                }
            }
        }
        object = new EDbid();
        ((EDbid)object).setUrl(System.getenv("REALM_URL"));
        ((EDbid)object).setUser(System.getenv("REALM_NAME"));
        ((EDbid)object).setPassword(System.getenv("REALM_PASSWORD"));
        this.makeDbidMap(element, (EDbid)object);
    }

    private void makeDriverList(Element element) {
        String string;
        NodeList nodeList = element.getElementsByTagName(DBDRIVER_CLASS_KEY);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            this.driverList.add(element2.getTextContent());
        }
        if (this.driverList.isEmpty() && (string = System.getenv("REALM_DRIVER")) != null && string.length() > 0) {
            this.driverList.add(string);
        }
        if (this.driverList.isEmpty()) {
            this.driverList.add(DEFAULT_DRIVER);
        }
    }

    private void makeDbidMap(Element element, EDbid eDbid) {
        NodeList nodeList = element.getElementsByTagName("dbid");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            ForEachObject forEachObject = new ForEachObject(element2);
            while (forEachObject.hasNext()) {
                NodeList nodeList2 = element2.getChildNodes();
                int n2 = nodeList2.getLength();
                EDbid eDbid2 = eDbid.clone();
                for (int j = 0; j < n2; ++j) {
                    Node node = nodeList2.item(j);
                    if (node.getNodeType() != 1) continue;
                    Element element3 = (Element)node;
                    String string2 = element3.getTagName();
                    String string3 = forEachObject.getText(element3.getTextContent());
                    if ("dbidKey".equals(string2)) {
                        if (string3 == null || string3.length() <= 0) continue;
                        eDbid2.setDbidKey(string3.toUpperCase(Locale.JAPAN));
                        continue;
                    }
                    if ("title".equals(string2)) {
                        eDbid2.setTitle(string3);
                        continue;
                    }
                    if ("url".equals(string2)) {
                        eDbid2.setUrl(string3);
                        continue;
                    }
                    if ("user".equals(string2)) {
                        eDbid2.setUser(string3);
                        continue;
                    }
                    if ("password".equals(string2)) {
                        eDbid2.setPassword(string3);
                        continue;
                    }
                    if ("readonly".equals(string2)) {
                        eDbid2.setReadonly(string3);
                        continue;
                    }
                    if ("mincount".equals(string2)) {
                        eDbid2.setMincount(string3);
                        continue;
                    }
                    if ("maxcount".equals(string2)) {
                        eDbid2.setMaxcount(string3);
                        continue;
                    }
                    if ("pooltime".equals(string2)) {
                        eDbid2.setPooltime(string3);
                        continue;
                    }
                    if ("applicationInfo".equals(string2)) {
                        eDbid2.setApplicationInfo(string3);
                        continue;
                    }
                    if ("property".equals(string2)) {
                        eDbid2.addProp(string3);
                        continue;
                    }
                    System.err.println("\u8b66\u544a\uff1adbid \u306b\u65b0\u3057\u3044\u5c5e\u6027\u304c\u3001\u8ffd\u52a0\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
                }
                this.dbidMap.put(eDbid2.getDbidKey(), eDbid2);
            }
        }
        this.dbidMap.computeIfAbsent("DEFAULT", string -> eDbid.clone("DEFAULT"));
        this.dbidMap.computeIfAbsent("RESOURCE", string -> eDbid.clone("RESOURCE"));
    }

    public static String[] getDbidInfoKeys() {
        return (String[])DBID_INFO_KEYS.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getDbidInfo() {
        Map<String, EDbid> map = this.dbidMap;
        synchronized (map) {
            String[][] stringArray = new String[this.dbidMap.size()][DBID_INFO_KEYS.length];
            int n = 0;
            for (EDbid eDbid : this.dbidMap.values()) {
                stringArray[n][0] = eDbid.getDbidKey();
                stringArray[n][1] = eDbid.getTitle();
                stringArray[n][2] = eDbid.getUrl();
                stringArray[n][3] = eDbid.getUser();
                stringArray[n][4] = eDbid.getPassword();
                stringArray[n][5] = String.valueOf(eDbid.isReadonly());
                stringArray[n][6] = String.valueOf(eDbid.getMincount());
                stringArray[n][7] = String.valueOf(eDbid.getMaxcount());
                stringArray[n][8] = String.valueOf(eDbid.getPooltime());
                stringArray[n][9] = String.valueOf(eDbid.isApplicationInfo());
                stringArray[n][10] = String.valueOf(eDbid.getProps().toString());
                ++n;
            }
            return stringArray;
        }
    }

    public void setDbidInfo(String[][] stringArray) {
        FileUtil.copy(this.xmlFilename, this.xmlFilename + "_" + System.currentTimeMillis());
        Document document = DomParser.read(new File(this.xmlFilename));
        Element element = document.getDocumentElement();
        this.deleteChildElements(element, "dbid");
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = document.createElement("dbid");
                for (int j = 0; j < stringArray[i].length; ++j) {
                    Element element3 = document.createElement(DBID_INFO_KEYS[j]);
                    element3.setTextContent(stringArray[i][j]);
                    element2.appendChild(element3);
                }
                element.appendChild(element2);
                element.appendChild(document.createTextNode("\n\n"));
            }
        }
        DomParser.write(new File(this.xmlFilename), document);
        this.reload();
    }

    public static String getDriverKey() {
        return DBDRIVER_CLASS_KEY;
    }

    public String[] getDriverList() {
        return this.driverList.toArray(new String[this.driverList.size()]);
    }

    public void setDriverList(String ... stringArray) {
        FileUtil.copy(this.xmlFilename, this.xmlFilename + "_" + System.currentTimeMillis());
        Document document = DomParser.read(new File(this.xmlFilename));
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagName("dbDriver").item(0);
        this.deleteChildElements(element2, DBDRIVER_CLASS_KEY);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                Element element3 = document.createElement(DBDRIVER_CLASS_KEY);
                element3.setTextContent(stringArray[i]);
                element2.appendChild(element3);
            }
        }
        DomParser.write(new File(this.xmlFilename), document);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodeKeyVal() {
        if (this.codeKeyVal == null) {
            StringBuilder stringBuilder = new StringBuilder(200);
            Map<String, EDbid> map = this.dbidMap;
            synchronized (map) {
                for (EDbid eDbid : this.dbidMap.values()) {
                    String string = eDbid.getDbidKey();
                    String string2 = StringUtil.nval(eDbid.getTitle(), string);
                    if (string2.indexOf(32) >= 0) {
                        stringBuilder.append('\"').append(string).append(':').append(string2).append('\"');
                    } else {
                        stringBuilder.append(string).append(':').append(string2);
                    }
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            this.codeKeyVal = stringBuilder.toString();
        }
        return this.codeKeyVal;
    }

    private void deleteChildElements(Element element, String string) {
        Node node = element.getFirstChild();
        boolean bl = false;
        while (node != null) {
            if (node.getNodeType() == 1) {
                bl = ((Element)node).getTagName().equalsIgnoreCase(string);
            }
            Node node2 = node.getNextSibling();
            if (bl) {
                element.removeChild(node);
            }
            node = node2;
        }
    }

    private static final class ForEachObject {
        private final String attVar;
        private final String[] items;
        private int idx = -1;

        public ForEachObject(Element element) {
            if (element.hasAttributes()) {
                NamedNodeMap namedNodeMap = element.getAttributes();
                String string = this.getAttri(namedNodeMap, "var");
                this.attVar = StringUtil.isNull(string) ? null : "${" + string + "}";
                String string2 = this.getAttri(namedNodeMap, "items");
                if (StringUtil.isNull(string2)) {
                    String string3 = this.getAttri(namedNodeMap, "begin");
                    String string4 = this.getAttri(namedNodeMap, "end");
                    int n = StringUtil.nval(this.getAttri(namedNodeMap, "step"), 1);
                    String string5 = this.getAttri(namedNodeMap, "type");
                    if ("month".equalsIgnoreCase(string5)) {
                        this.items = HybsDateUtil.stepYM(string3, string4, n);
                    } else {
                        int n2 = StringUtil.nval(string3, 0);
                        int n3 = StringUtil.nval(string4, n2 + 1);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (int i = n2; i < n3; i += n) {
                            arrayList.add(String.valueOf(i));
                        }
                        this.items = arrayList.toArray(new String[arrayList.size()]);
                    }
                } else {
                    this.items = string2.split(",");
                }
            } else {
                this.attVar = null;
                this.items = new String[]{"0"};
            }
        }

        public boolean hasNext() {
            return ++this.idx < this.items.length;
        }

        public String getText(String string) {
            String string2 = StringUtil.replace(string, this.attVar, this.items[this.idx]);
            string2 = StringUtil.replaceText(string2, "${env.", "}", System::getenv);
            string2 = StringUtil.replaceText(string2, "{@DATE.", "}", HybsDateUtil::getDateFormat);
            return string2;
        }

        private String getAttri(NamedNodeMap namedNodeMap, String string) {
            Node node = namedNodeMap.getNamedItem(string);
            String string2 = node == null ? null : node.getNodeValue();
            string2 = StringUtil.replaceText(string2, "${env.", "}", System::getenv);
            string2 = StringUtil.replaceText(string2, "{@DATE.", "}", HybsDateUtil::getDateFormat);
            return string2;
        }
    }
}

