/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.model.ArrayDataModel;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.FileInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsOverflowException;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.ColumnActionListener;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.io.TableReader;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.ReadTableTag;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class DirectTableInsertTag
extends ReadTableTag {
    private static final String VERSION = "7.0.4.3 (2019/07/15)";
    private static final long serialVersionUID = 704320190715L;
    private static final String DEFAULT_OMIT = "WRITABLE,ROWID";
    private String dbid;
    private int commitBatch;
    private String sql;
    private String table;
    private long dyStart;
    private boolean useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");

    @Override
    public int doStartTag() {
        this.dyStart = System.currentTimeMillis();
        this.addOmitNames(DEFAULT_OMIT);
        return this.table == null || this.table.isEmpty() ? 2 : 0;
    }

    @Override
    public int doAfterBody() {
        this.sql = this.getBodyString();
        if (this.sql == null || this.sql.isEmpty() || this.sql.trim().isEmpty()) {
            throw new HybsSystemException("table\u5c5e\u6027\u3092\u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u3001BODY \u90e8\u306e\u767b\u9332\u7528 Insert/Update\u6587\u306f\u3001\u5fc5\u9808\u3067\u3059\u3002");
        }
        return 0;
    }

    @Override
    protected int afterEnd() {
        ErrorMessage errorMessage = this.clmAct.getErrorMessage();
        if (!errorMessage.isOK()) {
            this.jspPrint(TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource()));
            return 5;
        }
        if (this.displayMsg != null && this.displayMsg.length() > 0) {
            String string = this.executeCount + this.getResource().getLabel(this.displayMsg);
            this.jspPrint(string + BR);
        }
        this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
        if (this.executeCount == 0 && this.stopZero) {
            return 5;
        }
        long l = System.currentTimeMillis() - this.dyStart;
        GUIInfo gUIInfo = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (gUIInfo != null) {
            gUIInfo.addWriteCount(this.executeCount, l, this.sql);
        }
        if (this.useTimeView) {
            this.jspPrint("<div id=\"queryTime\" value=\"" + l + "\"></div>");
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.dbid = null;
        this.commitBatch = 0;
        this.table = null;
        this.useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
    }

    @Override
    protected void create(final File file) {
        try (final Transaction transaction = this.getTransaction();){
            ColumnActionListener columnActionListener = new ColumnActionListener(){
                private DBColumn[] dbClms;
                private String[] clmKeys;
                private int commitCount;
                private int[] clmNos;
                private int clmNosLen;
                private PreparedStatement pstmt;
                private final Connection conn;
                {
                    this.conn = transaction.getConnection(DirectTableInsertTag.this.dbid);
                }

                @Override
                public void end() {
                    Closer.stmtClose((Statement)this.pstmt);
                    transaction.commit();
                }

                @Override
                public void columnNames(String[] stringArray) {
                    Object object;
                    Object object2;
                    String string = null;
                    CharSequence[] charSequenceArray = DirectTableInsertTag.this.clmAct.makeNames(stringArray);
                    if (DirectTableInsertTag.this.table == null || DirectTableInsertTag.this.table.isEmpty()) {
                        if (DirectTableInsertTag.this.sql != null && !DirectTableInsertTag.this.sql.isEmpty()) {
                            object2 = new ArrayDataModel((String[])charSequenceArray, true);
                            object = new Formatter((DataModel)object2, DirectTableInsertTag.this.sql.trim());
                            this.clmNos = object.getClmNos();
                            this.clmNosLen = this.clmNos.length;
                            this.clmKeys = object.getClmKeys();
                            string = object.getQueryFormatString();
                        }
                    } else {
                        if ("FILE.NAME".equals(DirectTableInsertTag.this.table)) {
                            DirectTableInsertTag.this.table = FileInfo.getNAME((File)file);
                        }
                        this.clmNosLen = charSequenceArray.length;
                        this.clmNos = new int[this.clmNosLen];
                        this.clmKeys = charSequenceArray;
                        object2 = new StringBuilder(200);
                        ((StringBuilder)object2).append("INSERT INTO ").append(DirectTableInsertTag.this.table).append(" ( ").append(String.join((CharSequence)",", charSequenceArray)).append(" ) VALUES ( ?");
                        this.clmNos[0] = 0;
                        for (int i = 1; i < this.clmNosLen; ++i) {
                            this.clmNos[i] = i;
                            ((StringBuilder)object2).append(",?");
                        }
                        ((StringBuilder)object2).append(')');
                        string = ((StringBuilder)object2).toString();
                    }
                    try {
                        this.pstmt = this.conn.prepareStatement(string);
                    }
                    catch (SQLException sQLException) {
                        object = CommonTagSupport.CR + sQLException.getMessage() + CommonTagSupport.CR + " sql   =[" + DirectTableInsertTag.this.sql + "]" + CommonTagSupport.CR + " names =[" + StringUtil.array2csv((String[])stringArray) + "]" + CommonTagSupport.CR + " encode=[" + DirectTableInsertTag.this.encode + "]" + CommonTagSupport.CR + " ErrorCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CommonTagSupport.CR;
                        DirectTableInsertTag.this.jspPrint((String)object);
                        transaction.rollback();
                        DirectTableInsertTag.this.sqlError = true;
                        throw new HybsSystemException((String)object, sQLException);
                    }
                    this.dbClms = new DBColumn[charSequenceArray.length];
                    for (int i = 0; i < charSequenceArray.length; ++i) {
                        this.dbClms[i] = DirectTableInsertTag.this.getDBColumn(charSequenceArray[i]);
                    }
                    DirectTableInsertTag.this.executeCount = 0;
                }

                @Override
                public void values(String[] stringArray, int n) {
                    if (DirectTableInsertTag.this.maxRowCount <= 0 || DirectTableInsertTag.this.executeCount <= DirectTableInsertTag.this.maxRowCount) {
                        if (this.pstmt == null || this.clmNos == null) {
                            throw new OgRuntimeException("#columnNames(String[])\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002");
                        }
                        try {
                            String[] stringArray2 = DirectTableInsertTag.this.clmAct.clmAction(stringArray, this.dbClms, n);
                            if (stringArray2 == null || !DirectTableInsertTag.this.clmAct.getErrorMessage().isOK() || DirectTableInsertTag.this.sqlError) {
                                return;
                            }
                            for (int i = 0; i < this.clmNosLen; ++i) {
                                this.pstmt.setString(i + 1, stringArray2[this.clmNos[i]]);
                            }
                            this.pstmt.execute();
                            if (DirectTableInsertTag.this.commitBatch > 0 && DirectTableInsertTag.this.executeCount % DirectTableInsertTag.this.commitBatch == 0) {
                                this.conn.commit();
                                this.commitCount = DirectTableInsertTag.this.executeCount;
                            }
                            ++DirectTableInsertTag.this.executeCount;
                        }
                        catch (SQLException sQLException) {
                            String string = CommonTagSupport.CR + sQLException.getMessage() + CommonTagSupport.CR + " sql   =[" + DirectTableInsertTag.this.sql + "]" + CommonTagSupport.CR + " encode=[" + DirectTableInsertTag.this.encode + "]" + CommonTagSupport.CR + " keys  =[" + StringUtil.array2csv((String[])this.clmKeys) + "]" + CommonTagSupport.CR + " vals  =[" + StringUtil.array2csv((String[])stringArray) + "]" + CommonTagSupport.CR + " \u884c\u756a\u53f7=[" + (n + 1) + "] \u767b\u9332\u4ef6\u6570=[" + this.commitCount + "]" + CommonTagSupport.CR + " ErrorCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CommonTagSupport.CR;
                            DirectTableInsertTag.this.jspPrint(string);
                            transaction.rollback();
                            DirectTableInsertTag.this.sqlError = true;
                            throw new HybsSystemException(string, sQLException);
                        }
                    } else {
                        throw new HybsOverflowException(DirectTableInsertTag.this.maxRowCount);
                    }
                }
            };
            TableReader tableReader = (TableReader)HybsSystem.newInstance("TableReader_", this.readerClass);
            tableReader.setSeparator(this.separator);
            tableReader.setColumns(this.columns);
            tableReader.setUseNumber(this.useNumber);
            tableReader.setSkipRowCount(this.skipRowCount);
            tableReader.setDebug(this.isDebug());
            tableReader.setSheetName(this.sheetName);
            tableReader.setSheetNos(this.sheetNos);
            tableReader.setSheetConstData(this.sheetConstKeys, this.sheetConstAdrs);
            tableReader.setNullBreakClm(this.nullBreakClm);
            tableReader.setNullSkipClm(this.nullSkipClm);
            tableReader.setColumnActionListener(columnActionListener);
            tableReader.readDBTable(file, this.encode);
            columnActionListener.end();
        }
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setCommitBatch(String string) {
        this.commitBatch = StringUtil.nval((String)this.getRequestParameter(string), (int)this.commitBatch);
    }

    public void setTable(String string) {
        this.table = StringUtil.nval((String)this.getRequestParameter(string), (String)this.table);
    }

    public void setUseTimeView(String string) {
        this.useTimeView = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTimeView);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("sql", (Object)this.sql).println("commitBatch", (Object)this.commitBatch).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

