/*
 * Copyright (C) 2006-2007 Speecys Corporation
 *		Toshiaki Nozawa <nozawa@speecys.com>
 * All rights reserved.
 */

#ifndef __LIBLED_H__
#define __LIBLED_H__
#include <stdbool.h>
#include <sys/types.h>
#include "rs485devs.h"

#define GET_e_LedBoardID(offset)	(offset + BREST_LED)
#define GET_e_LedBoardID_OFFSET(id)	(id - BREST_LED)

#define	LED_DATA_LEN	(int)(LED_ROW * LED_COLUMN / (8 / LED_PIXEL_DEPTH_BIT))
#define LED_PIX_IN_BYTE	(int)(CHAR_BIT / LED_PIXEL_DEPTH_BIT)
#define LED_ROW					5
#define LED_COLUMN				12

/**
 * variables, structur declaration
 */
enum e_LedBoardID	{BREST_LED = rs485ID_LED_BREST, LEFT_LED, RIGHT_LED
			, HEAD_LED, LED_BROADCAST = 254, NUM_e_LedBoardID = 3};
enum e_LedSwFunc	{GET_SW_INF, CLR_AND_GET_SW_INF};
enum e_LedSwAlign	{LedSwAlign_BRight, LedSwAlign_BCent, LedSwAlign_BLeft,
			    LedSwAlign_RThumb = 0, LedSwAlign_RLittle,
			    LedSwAlign_LLittle= 0, LedSwAlign_LThumb,
			    NUM_PUSH_SWITCH_ON_LED = 3};
enum e_LedColorCode {LED_BLANK, LED_RED, LED_GREEN
					, LED_PIXEL_DEPTH_BIT = 2};
enum e_ledPattern {
	BLANK
	, SL_STRIPE_MIX1, SL_STRIPE_MIX2, 	DUAL_DIA_MIX, CENT_CIRCLE_MIX
	, CHECKER_MIX1, CHECKER_MIX2
	, RIPPLE_MIX1st, RIPPLE_MIX2nd, RIPPLE_MIX3rd, RIPPLE_MIX4th
	, INVASION_MIX1st, INVASION_MIX2nd, INVASION_MIX3rd
	, INVASION_MIX4th, INVASION_MIX5th, INVASION_MIX6th
	, INVASION_MIX7th, INVASION_MIX8th, INVASION_MIX9th
	, INVASION_MIX10th
	, MESURINGWORM1st, MESURINGWORM2nd, MESURINGWORM3rd
	, MESURINGWORM4th, MESURINGWORM5th, MESURINGWORM6th
	, MESURINGWORM7th, MESURINGWORM8th, MESURINGWORM9th
	, MESURINGWORM10th
	, OK_MARK, NG_MARK, OK__NG_MARK

	, NUM_e_ledPattern
};


struct ledSwitchInf {
    uint16_t contTimes;
    uint16_t pushCnt;
};

/**
 * prototype declaration
 */
void initLedPtn(void);
bool ledPixelCheck(int row, int column);
size_t editLedDispReq(enum e_LedBoardID ledId, const u_char *pat, u_char *buf
    , size_t bLen);
size_t editLedDispFixpat(enum e_LedBoardID ledId, enum e_ledPattern pat
    , /*@out@*/u_char *buf, size_t bLen);
/**
 * set LED data, should call editLedDispReq() after this func
 */
void ledPset(int row, int clm, enum e_LedColorCode col, u_char *pat);
void ledVertLineDisp(int clm, enum e_LedColorCode col, u_char *pat);
/**
 * display speaker volume level
 * @param lvl
 */
void led_VolLevel(enum e_LedBoardID id, int lvl);

#endif	//__LIBLED_H__
