/*
 * Copyright (C) 2004-2007 Speecys Corporation
 *		Toshiaki Nozawa <nozawa@speecys.com>
 * All rights reserved.
 */

#ifndef __LIBUTIL_H__
#define __LIBUTIL_H__

#include <sys/time.h>
#include <sys/uio.h>
#include <stdbool.h>

#include "scifTrafMain.h"

#define ARR_LEN(array)	(sizeof array/ sizeof array[0])

/**
 * convert usec to 'struct timeval'
 */
struct timeval *usec2tv(time_t usec
    , /*@out@*/struct timeval *tv);
    		
int open_cli_sock(const char *srvName, const char *srvPort);
ssize_t readPacket(int d, struct iovec *iovec, bool ntohF, bool readBlkF);
ssize_t writePacket(int d, uint32_t seq, uint16_t pri, uint16_t cat
    , uint16_t flg, uint16_t datLen
    , /*@out@*//*@null@*/void *dat, bool htonF);
size_t rs485_make_packet(/*@out@*/u_char *pcmdbuf
    , u_char id, u_char flag
    , u_char address, u_char length, u_char count
    , /*@null@*/const u_char *pdata);
int rs485_make_long_packet(u_char *pcmdbuf, u_char flag, u_char address
    , u_char length, u_char count, const u_char *pdata);
uint16_t set485devShort(/*@out@*/u_char dst[sizeof(short)], uint16_t src);
uint16_t get485devShort(u_char src[sizeof(short)]);
#endif	//__LIBUTIL_H__
