/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.vrm;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import org.logical_paradox.common.io.AvailableList;
import org.logical_paradox.common.util.Cache;
import org.logical_paradox.common.util.PriorityCache;
import org.logical_paradox.common.vrm.AvailableRecord;

public class VRMAvailableList
extends AvailableList {
    private long offset;

    public VRMAvailableList(String filename) {
        super(filename);
    }

    public VRMAvailableList(String filename, int size) {
        super(filename, size);
    }

    protected Cache createCache(int size) {
        return new PriorityCache(size, 1);
    }

    protected void restore(ByteBuffer buffer) throws IOException {
        this.offset = buffer.hasRemaining() ? buffer.getLong() : 0L;
        while (buffer.hasRemaining()) {
            int availableRecordSize = buffer.getInt();
            long nextptr = buffer.getLong();
            this.cache.add((Object)new AvailableRecord(availableRecordSize, nextptr));
            if (nextptr < 0L) break;
        }
    }

    public void setOffset(long o) {
        this.offset = o;
    }

    public long getOffset() {
        return this.offset;
    }

    public void flush() throws IOException {
        OutputStream out = this.getOutputStream();
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(this.offset);
        ((Buffer)buffer).rewind();
        out.write(buffer.array());
        AvailableRecord ar = null;
        Iterator it = this.cache.iterator();
        while (it.hasNext()) {
            ar = (AvailableRecord)it.next();
            out.write(ar.byteStream());
        }
        out.flush();
        out.close();
    }
}

