/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.vrm;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.logical_paradox.common.io.CommonRandomAccessFileDelegator;
import org.logical_paradox.common.io.RandomAccessFileDelegator;
import org.logical_paradox.common.vrm.AvailableRecord;
import org.logical_paradox.common.vrm.Record;
import org.logical_paradox.common.vrm.RecordFactory;
import org.logical_paradox.common.vrm.VRMAvailableList;

public class VariableRecordManager {
    protected String filename;
    protected RandomAccessFileDelegator file;
    protected VRMAvailableList availableList;
    protected RecordFactory factory;

    public VariableRecordManager(String filename, RecordFactory factory) throws IOException {
        this.filename = filename;
        this.factory = factory;
        this.open();
    }

    public void open() throws IOException {
        this.file = new CommonRandomAccessFileDelegator(this.filename, "rw");
        this.availableList = new VRMAvailableList(String.valueOf(this.filename) + ".vra");
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
        if (this.availableList != null) {
            this.availableList.flush();
            this.availableList = null;
        }
    }

    public long insert(Record r) throws IOException {
        int emptyRecordSize;
        long offset = -1L;
        AvailableRecord emptyRecord = (AvailableRecord)this.availableList.getCache().getOne();
        if (emptyRecord == null) {
            offset = this.file.length();
        } else if (emptyRecord.getRecordSize() < r.size()) {
            offset = this.file.length();
            this.availableList.getCache().add((Object)emptyRecord);
        } else {
            offset = this.availableList.getOffset();
        }
        this.file.seek(offset);
        this.file.write(r.byteStream());
        if (emptyRecord != null && (emptyRecordSize = emptyRecord.getRecordSize() - r.getRecordSize()) > 0) {
            this.availableList.getCache().add((Object)new AvailableRecord(emptyRecordSize, offset + (long)r.size()));
        }
        return offset;
    }

    public void update(long rno, Record r) throws IOException {
        Record pre = this.get(rno);
        if (pre.size() != r.size()) {
            this.delete(rno);
            this.insert(r);
        }
    }

    public Record get(long rno) throws IOException {
        this.file.seek(rno);
        byte[] recordSizeBuffer = new byte[4];
        this.file.read(recordSizeBuffer);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        ((Buffer)buffer).rewind();
        buffer.put(recordSizeBuffer);
        ((Buffer)buffer).rewind();
        int recordSize = buffer.getInt();
        byte[] recordBody = new byte[recordSize];
        this.file.read(recordBody);
        return this.factory.getRecord(recordBody);
    }

    public void delete(long rno) throws IOException {
        Record r = this.get(rno);
        AvailableRecord ar = new AvailableRecord(r.getRecordSize(), rno);
        this.availableList.getCache().add((Object)ar);
    }
}

