/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree;

import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeFile;
import org.logical_paradox.common.btree.BtreeFileMoc;
import org.logical_paradox.common.btree.BtreePage;
import org.logical_paradox.common.io.MemoryMappedRandomAccessFile;

public class BtreeFileTest
extends TestCase {
    private static final int ORDER = 32;
    private BtreeFactory _factory;

    public void testSetProperty() throws Exception {
        Properties prop = new Properties();
        try {
            BtreeFileMoc btf1 = new BtreeFileMoc(this._factory, prop);
            Assert.fail((String)"\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u5185\u5bb9\u304c\u4e0d\u5341\u5206\u306a\u306e\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u306a\u304b\u3063\u305f");
        }
        catch (BtreeException btf1) {
            // empty catch block
        }
        prop.setProperty("btreefile.filename", "btree.idx");
        prop.setProperty("btreefile.magicnumber", "ABCD");
        prop.setProperty("btreefile.majorversion", "100");
        prop.setProperty("btreefile.minorversion", "200");
        prop.setProperty("btreefile.headersize", "256");
        prop.setProperty("btreefile.order", "64");
        prop.setProperty("btreefile.keysize", "32");
        try {
            BtreeFileMoc btf2 = new BtreeFileMoc(this._factory, prop);
        }
        catch (BtreeException e2) {
            Assert.fail((String)"\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u5185\u5bb9\u304c\u5341\u5206\u306a\u306e\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f1");
        }
        prop.setProperty("btreefile.rootpage", "100");
        prop.setProperty("btreefile.maxassignedpage", "500");
        try {
            BtreeFileMoc btf3 = new BtreeFileMoc(this._factory, prop);
        }
        catch (BtreeException e3) {
            Assert.fail((String)"\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u5185\u5bb9\u304c\u5341\u5206\u306a\u306e\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f2");
        }
    }

    public void testflush() throws Exception {
        BtreeFile btf1 = this._factory.getFileHandle("1");
        BtreeFile btf2 = this._factory.getFileHandle("1");
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        btf1._btfile = file;
        byte[] magicno = new byte[]{66, 89, 84, 69};
        btf1.setMagicNumber(magicno);
        btf1.setVersion(5, 2);
        btf1.flush();
        file.seek(0L);
        btf2._btfile = file;
        btf2.reload();
        Assert.assertEquals((String)"\u30de\u30b8\u30c3\u30af\u30ca\u30f3\u30d0\u30fc\u306e\u30bb\u30c3\u30c8\u306b\u554f\u984c\u304c\u3042\u308b", (String)"BYTE", (String)btf2.getMagicNumber());
        Assert.assertEquals((String)"\u30e1\u30b8\u30e3\u30fc\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u30bb\u30c3\u30c8\u306b\u554f\u984c\u304c\u3042\u308b", (int)5, (int)btf2.getMajorVersion());
        Assert.assertEquals((String)"\u30de\u30a4\u30ca\u30fc\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u30bb\u30c3\u30c8\u306b\u554f\u984c\u304c\u3042\u308b", (int)2, (int)btf2.getMinorVersion());
    }

    public void testSetMagicNumber() throws Exception {
        BtreeFile btf1 = this._factory.getFileHandle("1");
        byte[] magicno = new byte[]{66, 89, 84, 69};
        btf1.setMagicNumber(magicno);
        byte[] magicno4 = new byte[]{};
        try {
            btf1.setMagicNumber(magicno4);
            Assert.fail((String)"\u30d0\u30a4\u30c8\u914d\u52170\u306a\u306e\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u306a\u304b\u3063\u305f");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        byte[] magicno2 = new byte[3];
        try {
            btf1.setMagicNumber(magicno2);
            Assert.fail((String)"\u30d0\u30a4\u30c8\u914d\u5217\u304c\u5c11\u306a\u3044\u306e\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u306a\u304b\u3063\u305f");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        byte[] magicno3 = new byte[5];
        try {
            btf1.setMagicNumber(magicno3);
            Assert.fail((String)"\u30d0\u30a4\u30c8\u914d\u5217\u304c\u591a\u3044\u306e\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u306a\u304b\u3063\u305f");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testReplaceRootPageNo() throws Exception {
        BtreeFile btf1 = this._factory.getFileHandle("1");
        BtreeFile btf2 = this._factory.getFileHandle("1");
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        btf1._btfile = file;
        btf1.replaceRootPageNo(12393L);
        btf1.flush();
        btf2._btfile = file;
        btf2.reload();
        Assert.assertEquals((String)"\u30eb\u30fc\u30c8\u30da\u30fc\u30b8\u756a\u53f7\u304c\u6b63\u3057\u304f\u8aad\u307f\u66f8\u304d\u3067\u304d\u306a\u304b\u3063\u305f", (long)12393L, (long)btf2.getRootPageNo());
    }

    public void testFlush() throws Exception {
        BtreeFile btf1 = this._factory.getFileHandle("1");
        btf1._btfile = new MemoryMappedRandomAccessFile();
        btf1._sizeOfHeader = 256;
        btf1.flush();
    }

    public void testNewPage() throws Exception {
        BtreeFile btf1 = this._factory.getFileHandle("1");
        BtreeFile btf2 = this._factory.getFileHandle("1");
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        btf1._btfile = file;
        btf1._maxAssignedPageNo = 0L;
        BtreePage btp = btf1.newPage();
        btf1.flush();
        Assert.assertEquals((String)"\u6700\u5927\u30da\u30fc\u30b8\u756a\u53f7\u304c\u66f4\u65b0\u3055\u308c\u306a\u3044", (long)1L, (long)btf1.getMaxAssignedPageNo());
        Assert.assertNotNull((String)"\u30da\u30fc\u30b8\u304c\u4f5c\u6210\u3055\u308c\u306a\u304b\u3063\u305f", (Object)btp);
        btf2._btfile = file;
        btf2.reload();
        Assert.assertEquals((String)"\u30d5\u30a1\u30a4\u30eb\u4e0a\u306e\u6700\u5927\u30da\u30fc\u30b8\u304c\u66f4\u65b0\u3055\u308c\u3066\u3044\u306a\u3044", (long)1L, (long)btf2.getMaxAssignedPageNo());
    }

    public void testGetPage() throws Exception {
        BtreeFile btf1 = this._factory.getFileHandle("1");
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        btf1._btfile = file;
        BtreePage btp1 = btf1.newPage();
        btp1.insert(this._factory.newKey("\u3042\u3042\u3042"), 102L);
        btp1.insert(this._factory.newKey("\u3044\u3044\u3044"), -1L);
        btf1.replacePage(btp1);
        btf1.flush();
        BtreePage btp2 = btf1.getPage(btp1.getPageNo());
        Assert.assertEquals((long)btp1.getPageNo(), (long)btp2.getPageNo());
        Assert.assertEquals((Object)btp2.find("\u3042\u3042\u3042"), (Object)this._factory.newKey("\u3042\u3042\u3042"));
        Assert.assertEquals((Object)btp2.find("\u3044\u3044\u3044"), (Object)this._factory.newKey("\u3044\u3044\u3044"));
        Assert.assertEquals((long)-1L, (long)btp2.leftChildOf(this._factory.newKey("\u3042\u3042\u3042")));
        Assert.assertEquals((long)102L, (long)btp2.rightChildOf(this._factory.newKey("\u3042\u3042\u3042")));
        Assert.assertEquals((long)102L, (long)btp2.leftChildOf(this._factory.newKey("\u3044\u3044\u3044")));
        Assert.assertEquals((long)-1L, (long)btp2.rightChildOf(this._factory.newKey("\u3044\u3044\u3044")));
    }

    public void testDisablePage() throws Exception {
        BtreeFile btf1 = this._factory.getFileHandle("1");
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        btf1._btfile = file;
        BtreePage btp1 = btf1.newPage();
        btp1.insert(this._factory.newKey("\u3042\u3042\u3042"), 102L);
        btp1.insert(this._factory.newKey("\u3044\u3044\u3044"), -1L);
        btf1.replacePage(btp1);
        btf1.flush();
        long pagenoOfBtp1 = btp1.getPageNo();
        btp1.setEnabled(false);
        btf1.replacePage(btp1);
        BtreePage btp2 = btf1.getPage(pagenoOfBtp1);
        Assert.assertEquals((boolean)false, (boolean)btp2.isEnabled());
    }

    public void testRecycleDisabledPage() throws Exception {
        BtreeFile btf1 = this._factory.getFileHandle("1");
        MemoryMappedRandomAccessFile file = new MemoryMappedRandomAccessFile();
        btf1._btfile = file;
        BtreePage btp1 = btf1.newPage();
        btp1.insert(this._factory.newKey("\u3042\u3042\u3042"), 102L);
        btp1.insert(this._factory.newKey("\u3044\u3044\u3044"), -1L);
        btf1.replacePage(btp1);
        btf1.flush();
        long pagenoOfBtp1 = btp1.getPageNo();
        btp1.setEnabled(false);
        btf1.replacePage(btp1);
        btf1.flush();
        BtreePage btp2 = btf1.newPage();
        Assert.assertEquals((boolean)true, (boolean)btp2.isEnabled());
        Assert.assertEquals((long)pagenoOfBtp1, (long)btp2.getPageNo());
        Assert.assertEquals((long)-1L, (long)btp1.getPageNo());
    }

    public void setUp() throws Exception {
        this._factory = BtreeFactory.getInstance("org.logical_paradox.common.btree.BtreeFactoryTestImpl");
    }
}

