/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree.simulation.bts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import org.logical_paradox.common.btree.Btree;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.BtreePage;
import org.logical_paradox.common.btree.BtreeSession;
import org.logical_paradox.common.btree.simulation.bts.BtreeSimulatorMainPanel;
import org.logical_paradox.common.btree.simulation.bts.DrawableBtreeFactory;
import org.logical_paradox.common.btree.simulation.bts.DrawableBtreeKey;

public class Diagram {
    private static final int POINTER_WIDTH = 4;
    private final BtreeSimulatorMainPanel mainPanel;
    private BtreeSession session;

    public Diagram(BtreeSimulatorMainPanel panel) throws Exception {
        this.mainPanel = panel;
        this.session = Btree.getInstance(new DrawableBtreeFactory()).getSession();
        this.session.open("");
    }

    public void insert(String key) throws Exception {
        this.session.insert(new DrawableBtreeKey(key));
        this.repaint();
    }

    public void update(String src, String dest) throws Exception {
        this.repaint();
    }

    public void delete(String key) throws Exception {
        this.repaint();
    }

    public void repaint() {
        this.paint(this.mainPanel.getGraphics());
    }

    public void paint(Graphics g) {
        g.setColor(Color.BLACK);
        try {
            this.drawPage(g, this.session.getPage(), 0, 20);
        }
        catch (BtreeException e) {
            System.out.println("\u30da\u30fc\u30b8\u63cf\u753b\u4e2d\u306b\u4f55\u3089\u304b\u306e\u4f8b\u5916\u304c\u3067\u305f");
            e.printStackTrace();
        }
    }

    protected int drawPage(Graphics g, BtreePage btp, int level, int xoffset) {
        if (btp == null) {
            return 0;
        }
        BtreeKey[] keys = btp.getKeys();
        BtreePage childNode = null;
        int startx = xoffset;
        int childrenWidth = 0;
        int i = 0;
        while (i < btp.keyCount() + 1) {
            try {
                long childpageno = btp.getChildNodeAt(i);
                if (childpageno > 0L) {
                    childNode = this.session.getPage(childpageno);
                    int pagewidth = this.drawPage(g, childNode, level + 1, startx + childrenWidth);
                    childrenWidth += pagewidth + 10;
                }
            }
            catch (Exception be) {
                be.printStackTrace();
            }
            ++i;
        }
        int pageoffset = (childrenWidth - this.calcPageWidth(btp)) / 2;
        if (childrenWidth == 0) {
            pageoffset = 0;
        }
        System.out.println("childr=" + childrenWidth);
        System.out.println("pagewd=" + this.calcPageWidth(btp));
        System.out.println("startx=" + startx);
        System.out.println("poffst=" + pageoffset);
        return this.drawKeys(g, btp, level, startx + pageoffset);
    }

    protected int calcPageWidth(BtreePage btp) {
        BtreeKey[] keys = btp.getKeys();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < btp.keyCount()) {
            DrawableBtreeKey drawable = (DrawableBtreeKey)keys[i];
            Dimension d = drawable.getSize();
            width += d.width;
            if (height < d.height) {
                height = d.height;
            }
            width += 4;
            ++i;
        }
        if (keys.length > 0) {
            width += 4;
        }
        return width;
    }

    protected int drawKeys(Graphics g, BtreePage btp, int level, int xoffset) {
        BtreeKey[] keys = btp.getKeys();
        System.out.println("xoffset=" + xoffset);
        int width = this.calcPageWidth(btp);
        int height = 0;
        if (keys[0] != null) {
            height = ((DrawableBtreeKey)keys[0]).getSize().height;
        }
        int startx = xoffset;
        int starty = 48 + level * (height + 16);
        int cnt = 0;
        while (cnt < btp.keyCount()) {
            g.drawRect(startx, starty, 4, height);
            DrawableBtreeKey dbk = (DrawableBtreeKey)keys[cnt];
            dbk.draw(g, new Point(startx += 4, starty));
            startx += dbk.getSize().width;
            ++cnt;
        }
        g.drawRect(startx, starty, 4, height);
        startx += 4;
        return width;
    }
}

