/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree.simulation.bts;

import java.util.Hashtable;
import java.util.Properties;
import org.logical_paradox.common.btree.BtreeAvailableList;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeFile;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.OnMemoryBtreeFragmentFile;
import org.logical_paradox.common.btree.simulation.bts.BTSBtreeFile;
import org.logical_paradox.common.btree.simulation.bts.DrawableBtreeKey;

public class DrawableBtreeFactory
extends BtreeFactory {
    private static BtreeKey _key = null;
    protected static Properties _prop = null;

    static {
        _prop = new Properties();
        _prop.setProperty("btreefile.magicnumber", "DBTP");
        _prop.setProperty("btreefile.majorversion", "1");
        _prop.setProperty("btreefile.minorversion", "0");
        _prop.setProperty("btreefile.headersize", "128");
        _prop.setProperty("btreefile.order", "5");
        _prop.setProperty("btreefile.keysize", Integer.toString(16));
    }

    public Properties getProperty() throws BtreeException {
        return _prop;
    }

    public BtreeFile getFileHandle(String filename) throws BtreeException {
        Properties prop = (Properties)((Hashtable)this.getProperty()).clone();
        prop.setProperty("btreefile.filename", filename);
        return new BTSBtreeFile(this, prop);
    }

    public BtreeKey newKey(Object o) throws BtreeException {
        return new DrawableBtreeKey(o);
    }

    public BtreeKey newKey(byte[] stream) throws BtreeException {
        return new DrawableBtreeKey(stream);
    }

    public int keyByteSize() {
        return 16;
    }

    public BtreeAvailableList getBtreeAvailableList(String filename) throws BtreeException {
        return new OnMemoryBtreeFragmentFile();
    }
}

