/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.btree.simulation.bts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.common.btree.simulation.bts.BtreeSimulatorMainPanel;
import org.logical_paradox.common.btree.simulation.bts.Drawable;
import org.logical_paradox.common.util.StringUtils;

public class DrawableBtreeKey
extends BtreeKey
implements Drawable {
    public static final int KEY_BYTE_SIZE = 16;
    protected Rectangle rectangle;
    protected String _key;

    public DrawableBtreeKey(byte[] bstream) throws BtreeException {
        super(bstream);
    }

    public DrawableBtreeKey(Object o) throws BtreeException {
        super(o);
    }

    protected void objectToBtreeKey(Object o) throws BtreeException {
        if (!(o instanceof String)) {
            throw new BtreeException("\u5f15\u6570\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306fjava.lang.String\u306e\u307f\u6709\u52b9\u3067\u3059");
        }
        this._key = (String)o;
    }

    protected void byteStreamToBtreeKey(byte[] bstream) throws BtreeException {
        this._key = new String(bstream).trim();
    }

    public String toString() {
        return this._key;
    }

    public boolean equals(Object obj) {
        return this._key.equals(obj.toString());
    }

    public boolean isLessThan(BtreeKey key) {
        return this._key.compareTo(key.toString()) < 0;
    }

    public boolean isGreaterThan(BtreeKey key) {
        return this._key.compareTo(key.toString()) > 0;
    }

    public byte[] byteStream() {
        byte[] bytearray = new byte[16];
        byte[] thiskey = this._key.getBytes();
        System.arraycopy(thiskey, 0, bytearray, 0, thiskey.length);
        return bytearray;
    }

    public void draw(Graphics g, Point position) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(Color.ORANGE);
        g.fillRect(position.x, position.y, width, height);
        g.setColor(Color.BLACK);
        g.drawRect(position.x, position.y, width, height);
        FontMetrics metrics = BtreeSimulatorMainPanel.getFontMetrics();
        g.drawString(StringUtils.trimControlChars((String)this._key.trim()), position.x + 2, position.y + metrics.getAscent() + 2);
    }

    public Dimension getSize() {
        FontMetrics metrics = BtreeSimulatorMainPanel.getFontMetrics();
        char[] keychars = StringUtils.trimControlChars((String)this._key.trim()).toCharArray();
        int width = metrics.charsWidth(keychars, 0, keychars.length);
        int height = metrics.getHeight();
        return new Dimension(width + 4, height + 4);
    }
}

