/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BPage
implements Externalizable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    transient BTree _btree;
    protected transient long _recid;
    protected boolean _isLeaf;
    protected Object[] _keys;
    protected Object[] _values;
    protected int _first;
    protected long _previous;
    protected long _next;

    public BPage() {
    }

    BPage(BTree btree, int pageSize, boolean isLeaf) throws IOException {
        this._btree = btree;
        this._isLeaf = isLeaf;
        this._first = pageSize / 2;
        this._keys = new Object[pageSize];
        this._values = new Object[pageSize];
        this._recid = this._btree._recman.insert(this);
    }

    BPage(BTree btree, Object key, Object value, int pageSize) throws IOException {
        this._btree = btree;
        this._isLeaf = true;
        this._first = pageSize - 2;
        this._keys = new Object[pageSize];
        this._keys[pageSize - 2] = key;
        this._keys[pageSize - 1] = null;
        this._values = new Object[pageSize];
        this._values[pageSize - 2] = value;
        this._values[pageSize - 1] = null;
        this._recid = this._btree._recman.insert(this);
    }

    BPage(BTree btree, BPage root, BPage overflow, int pageSize) throws IOException {
        this._btree = btree;
        this._isLeaf = false;
        this._first = pageSize - 2;
        this._keys = new Object[pageSize];
        this._keys[pageSize - 2] = overflow.getLargestKey();
        this._keys[pageSize - 1] = root.getLargestKey();
        this._values = new Object[pageSize];
        this._values[pageSize - 2] = this.convertRecid(overflow._recid);
        this._values[pageSize - 1] = this.convertRecid(root._recid);
        this._recid = this._btree._recman.insert(this);
    }

    private void assert() {
        int i = this._first;
        while (i < this._keys.length - 1) {
            if (this.compare(this._keys[i], this._keys[i + 1]) >= 0) {
                this.dump(0);
                throw new Error("BPage not ordered");
            }
            ++i;
        }
    }

    void assertRecursive(int height) throws IOException {
        this.assert();
        if (--height > 0) {
            int i = this._first;
            while (i < this._keys.length) {
                if (this._keys[i] == null) break;
                BPage child = this.childBPage(i);
                if (this.compare(this._keys[i], child.getLargestKey()) != 0) {
                    this.dump(0);
                    child.dump(0);
                    throw new Error("Invalid child subordinate key");
                }
                child.assertRecursive(height);
                ++i;
            }
        }
    }

    BPage childBPage(int index) throws IOException {
        long recid = this.convertRecid(this._values[index]);
        return this.loadBPage(recid);
    }

    private final int compare(Object obj1, Object obj2) {
        if (obj1 == null) {
            return 1;
        }
        if (obj2 == null) {
            return -1;
        }
        return this._btree._comparator.compare(obj1, obj2);
    }

    private Object convertRecid(long recid) {
        return new Long(recid);
    }

    private long convertRecid(Object recid) {
        return (Long)recid;
    }

    private static void copyEntries(BPage source, int indexSource, BPage dest, int indexDest, int count) {
        System.arraycopy(source._keys, indexSource, dest._keys, indexDest, count);
        System.arraycopy(source._values, indexSource, dest._values, indexDest, count);
    }

    private void dump(int height) {
        String prefix = "";
        int i = 0;
        while (i < height) {
            prefix = String.valueOf(prefix) + "    ";
            ++i;
        }
        System.out.println(String.valueOf(prefix) + "-------------------------------------- BPage recid=" + this._recid);
        System.out.println(String.valueOf(prefix) + "first=" + this._first);
        int i2 = 0;
        while (i2 < this._keys.length) {
            System.out.println(String.valueOf(prefix) + "Bpage [" + i2 + "] " + this._keys[i2] + " " + this._values[i2]);
            ++i2;
        }
        System.out.println(String.valueOf(prefix) + "--------------------------------------");
    }

    void dumpRecursive(int height, int level) throws IOException {
        ++level;
        if (--height > 0) {
            int i = this._first;
            while (i < this._keys.length) {
                if (this._keys[i] == null) break;
                BPage child = this.childBPage(i);
                child.dump(level);
                child.dumpRecursive(height, level);
                ++i;
            }
        }
    }

    TupleBrowser find(int height, Object key) throws IOException {
        int index = this.findChildren(key);
        if (--height == 0) {
            return new Browser(this, index);
        }
        BPage child = this.childBPage(index);
        return child.find(height, key);
    }

    private int findChildren(Object key) {
        int left = this._first;
        int right = this._keys.length - 1;
        while (left < right) {
            int middle = (left + right) / 2;
            if (this.compare(this._keys[middle], key) < 0) {
                left = middle + 1;
                continue;
            }
            right = middle;
        }
        return right;
    }

    TupleBrowser findFirst() throws IOException {
        if (this._isLeaf) {
            return new Browser(this, this._first);
        }
        BPage child = this.childBPage(this._first);
        return child.findFirst();
    }

    Object getLargestKey() {
        return this._keys[this._keys.length - 1];
    }

    InsertResult insert(int height, Object key, Object value, boolean replace) throws IOException {
        InsertResult result;
        int index = this.findChildren(key);
        if (--height == 0) {
            result = new InsertResult();
            if (this.compare(key, this._keys[index]) == 0) {
                result._existing = this._values[index];
                if (replace) {
                    this._values[index] = value;
                    this._btree._cache.update(this._recid, this);
                }
                return result;
            }
        } else {
            BPage child = this.childBPage(index);
            result = child.insert(height, key, value, replace);
            if (result._existing != null) {
                return result;
            }
            if (result._overflow == null) {
                return result;
            }
            key = result._overflow.getLargestKey();
            value = this.convertRecid(result._overflow._recid);
            this._keys[index] = child.getLargestKey();
            result._overflow = null;
        }
        if (!this.isFull()) {
            BPage.insertEntry(this, index - 1, key, value);
            this._btree._cache.update(this._recid, this);
            return result;
        }
        int half = this._keys.length >> 1;
        BPage newPage = new BPage(this._btree, this._keys.length, this._isLeaf);
        if (index < half) {
            BPage.copyEntries(this, 0, newPage, half, index);
            BPage.setEntry(newPage, half + index, key, value);
            BPage.copyEntries(this, index, newPage, half + index + 1, half - index - 1);
        } else {
            BPage.copyEntries(this, 0, newPage, half, half);
            BPage.copyEntries(this, half, this, half - 1, index - half);
            BPage.setEntry(this, index - 1, key, value);
        }
        this._first = half - 1;
        int i = 0;
        while (i < this._first) {
            BPage.setEntry(this, i, null, null);
            ++i;
        }
        if (this._isLeaf) {
            newPage._previous = this._previous;
            newPage._next = this._recid;
            if (this._previous != 0L) {
                BPage previous = this.loadBPage(this._previous);
                previous._next = newPage._recid;
                this._btree._cache.update(this._previous, previous);
            }
            this._previous = newPage._recid;
        }
        this._btree._cache.update(this._recid, this);
        this._btree._cache.update(newPage._recid, newPage);
        result._overflow = newPage;
        return result;
    }

    private static void insertEntry(BPage page, int index, Object key, Object value) {
        Object[] keys = page._keys;
        Object[] values = page._values;
        int start = page._first;
        int count = index - page._first + 1;
        System.arraycopy(keys, start, keys, start - 1, count);
        System.arraycopy(values, start, values, start - 1, count);
        --page._first;
        keys[index] = key;
        values[index] = value;
    }

    boolean isEmpty() {
        return this._first == this._values.length - 1;
    }

    boolean isFull() {
        return this._first == 0;
    }

    private BPage loadBPage(long recid) throws IOException {
        try {
            BPage child = (BPage)this._btree._cache.fetchObject(recid);
            child._recid = recid;
            child._btree = this._btree;
            return child;
        }
        catch (ClassNotFoundException except) {
            throw new Error(except.toString());
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this._isLeaf = in.readBoolean();
        if (this._isLeaf) {
            this._previous = in.readLong();
            this._next = in.readLong();
        }
        this._first = in.readInt();
        this._keys = new Object[size];
        int i = this._first;
        while (i < size) {
            this._keys[i] = in.readObject();
            ++i;
        }
        this._values = new Object[size];
        int i2 = this._first;
        while (i2 < size) {
            this._values[i2] = in.readObject();
            ++i2;
        }
    }

    RemoveResult remove(int height, Object key) throws IOException {
        RemoveResult result;
        int half = this._keys.length / 2;
        int index = this.findChildren(key);
        if (--height == 0) {
            if (this.compare(this._keys[index], key) != 0) {
                throw new IllegalArgumentException("Key not found: " + key);
            }
            result = new RemoveResult();
            result._value = this._values[index];
            BPage.removeEntry(this, index);
            this._btree._cache.update(this._recid, this);
        } else {
            BPage child = this.childBPage(index);
            result = child.remove(height, key);
            this._keys[index] = child.getLargestKey();
            this._btree._cache.update(this._recid, this);
            if (result._underflow) {
                if (child._first != half + 1) {
                    throw new IllegalStateException("Error during underflow [1]");
                }
                if (index < this._values.length - 1) {
                    BPage brother = this.childBPage(index + 1);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first += steal;
                        child._first -= steal;
                        BPage.copyEntries(child, half + 1, child, half + 1 - steal, half - 1);
                        BPage.copyEntries(brother, bfirst, child, 2 * half - steal, steal);
                        int i = bfirst;
                        while (i < bfirst + steal) {
                            BPage.setEntry(brother, i, null, null);
                            ++i;
                        }
                        this._keys[index] = child.getLargestKey();
                        this._btree._cache.update(this._recid, this);
                        this._btree._cache.update(brother._recid, brother);
                        this._btree._cache.update(child._recid, child);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [2]");
                        }
                        brother._first = 1;
                        BPage.copyEntries(child, half + 1, brother, 1, half - 1);
                        this._btree._cache.update(brother._recid, brother);
                        BPage.copyEntries(this, this._first, this, this._first + 1, index - this._first);
                        BPage.setEntry(this, this._first, null, null);
                        ++this._first;
                        this._btree._cache.update(this._recid, this);
                        if (child._previous != 0L) {
                            BPage prev = this.loadBPage(child._previous);
                            prev._next = child._next;
                            this._btree._cache.update(prev._recid, prev);
                        }
                        if (child._next != 0L) {
                            BPage next = this.loadBPage(child._next);
                            next._previous = child._previous;
                            this._btree._cache.update(next._recid, next);
                        }
                        this._btree._recman.delete(child._recid);
                        this._btree._cache.invalidate(child._recid);
                    }
                } else {
                    BPage brother = this.childBPage(index - 1);
                    int bfirst = brother._first;
                    if (bfirst < half) {
                        int steal = (half - bfirst + 1) / 2;
                        brother._first += steal;
                        child._first -= steal;
                        BPage.copyEntries(brother, 2 * half - steal, child, half + 1 - steal, steal);
                        BPage.copyEntries(brother, bfirst, brother, bfirst + steal, 2 * half - bfirst - steal);
                        int i = bfirst;
                        while (i < bfirst + steal) {
                            BPage.setEntry(brother, i, null, null);
                            ++i;
                        }
                        this._keys[index - 1] = brother.getLargestKey();
                        this._btree._cache.update(this._recid, this);
                        this._btree._cache.update(brother._recid, brother);
                        this._btree._cache.update(child._recid, child);
                    } else {
                        if (brother._first != half) {
                            throw new IllegalStateException("Error during underflow [3]");
                        }
                        child._first = 1;
                        BPage.copyEntries(brother, half, child, 1, half);
                        this._btree._cache.update(child._recid, child);
                        BPage.copyEntries(this, this._first, this, this._first + 1, index - 1 - this._first);
                        BPage.setEntry(this, this._first, null, null);
                        ++this._first;
                        this._btree._cache.update(this._recid, this);
                        if (brother._previous != 0L) {
                            BPage prev = this.loadBPage(brother._previous);
                            prev._next = brother._next;
                            this._btree._cache.update(prev._recid, prev);
                        }
                        if (brother._next != 0L) {
                            BPage next = this.loadBPage(brother._next);
                            next._previous = brother._previous;
                            this._btree._cache.update(next._recid, next);
                        }
                        this._btree._recman.delete(brother._recid);
                        this._btree._cache.invalidate(brother._recid);
                    }
                }
            }
        }
        result._underflow = this._first > half;
        return result;
    }

    private static void removeEntry(BPage page, int index) {
        Object[] keys = page._keys;
        Object[] values = page._values;
        int start = page._first;
        int count = index - page._first;
        System.arraycopy(keys, start, keys, start + 1, count);
        keys[start] = null;
        System.arraycopy(values, start, values, start + 1, count);
        values[start] = null;
        ++page._first;
    }

    private static void setEntry(BPage page, int index, Object key, Object value) {
        page._keys[index] = key;
        page._values[index] = value;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._keys.length);
        out.writeBoolean(this._isLeaf);
        if (this._isLeaf) {
            out.writeLong(this._previous);
            out.writeLong(this._next);
        }
        out.writeInt(this._first);
        int i = this._first;
        while (i < this._keys.length) {
            out.writeObject(this._keys[i]);
            ++i;
        }
        int i2 = this._first;
        while (i2 < this._keys.length) {
            out.writeObject(this._values[i2]);
            ++i2;
        }
    }

    static class InsertResult {
        BPage _overflow;
        Object _existing;

        InsertResult() {
        }
    }

    static class RemoveResult {
        boolean _underflow;
        Object _value;

        RemoveResult() {
        }
    }

    static class Browser
    extends TupleBrowser {
        private BPage _page;
        private int _index;

        Browser(BPage page, int index) {
            this._page = page;
            this._index = index;
        }

        public boolean getNext(Tuple tuple) throws IOException {
            if (this._index < this._page._keys.length) {
                if (this._page._keys[this._index] == null) {
                    return false;
                }
            } else if (this._page._next != 0L) {
                this._page = this._page.loadBPage(this._page._next);
                this._index = this._page._first;
            }
            tuple.setKey(this._page._keys[this._index]);
            tuple.setValue(this._page._values[this._index]);
            ++this._index;
            return true;
        }

        public boolean getPrevious(Tuple tuple) throws IOException {
            if (this._index == this._page._first) {
                if (this._page._previous != 0L) {
                    this._page = this._page.loadBPage(this._page._previous);
                    this._index = this._page._keys.length;
                } else {
                    return false;
                }
            }
            --this._index;
            tuple.setKey(this._page._keys[this._index]);
            tuple.setValue(this._page._values[this._index]);
            return true;
        }
    }
}

