/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jdbm.btree.BPage;
import jdbm.helper.Comparator;
import jdbm.helper.ObjectCache;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import jdbm.recman.RecordManager;

public class BTree
implements Externalizable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    public static final int DEFAULT_SIZE = 16;
    protected transient RecordManager _recman;
    protected transient ObjectCache _cache;
    private transient long _recid;
    protected Comparator _comparator;
    private int _height;
    private transient long _root;
    private int _pageSize;
    protected int _size;

    public BTree() {
    }

    public BTree(RecordManager recman, ObjectCache cache, Comparator comparator) throws IOException {
        this(recman, cache, comparator, 16);
    }

    public BTree(RecordManager recman, ObjectCache cache, Comparator comparator, int pageSize) throws IOException {
        if (recman == null) {
            throw new IllegalArgumentException("Argument 'recman' is null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("Argument 'cache' is null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 'comparator' is null");
        }
        if ((pageSize & 1) != 0) {
            throw new IllegalArgumentException("Argument 'pageSize' must be even");
        }
        this._comparator = comparator;
        this._pageSize = pageSize;
        this._recman = recman;
        this._cache = cache;
        this._recid = this._recman.insert(this);
    }

    public synchronized TupleBrowser browse() throws IOException {
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            return EmptyBrowser.instance;
        }
        TupleBrowser browser = rootPage.findFirst();
        return browser;
    }

    public synchronized TupleBrowser browse(Object key) throws IOException {
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            return EmptyBrowser.instance;
        }
        TupleBrowser browser = rootPage.find(this._height, key);
        return browser;
    }

    public synchronized Object find(Object key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            return null;
        }
        Tuple tuple = new Tuple(null, null);
        TupleBrowser browser = rootPage.find(this._height, key);
        if (browser.getNext(tuple)) {
            if (this._comparator.compare(key, tuple.getKey()) != 0) {
                return null;
            }
            return tuple.getValue();
        }
        return null;
    }

    public synchronized Tuple findGreaterOrEqual(Object key) throws IOException {
        Tuple tuple = new Tuple(null, null);
        TupleBrowser browser = this.browse(key);
        if (browser.getNext(tuple)) {
            return tuple;
        }
        return null;
    }

    public long getRecid() {
        return this._recid;
    }

    private BPage getRoot() throws IOException {
        if (this._root == 0L) {
            return null;
        }
        try {
            BPage root = (BPage)this._cache.fetchObject(this._root);
            root._recid = this._root;
            root._btree = this;
            return root;
        }
        catch (ClassNotFoundException except) {
            throw new Error(except.toString());
        }
    }

    public synchronized Object insert(Object key, Object value, boolean replace) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' is null");
        }
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            rootPage = new BPage(this, key, value, this._pageSize);
            this._root = rootPage._recid;
            this._height = 1;
            this._size = 1;
            this._cache.update(this._recid, this);
            return null;
        }
        BPage.InsertResult insert = rootPage.insert(this._height, key, value, replace);
        boolean dirty = false;
        if (insert._overflow != null) {
            rootPage = new BPage(this, rootPage, insert._overflow, this._pageSize);
            this._root = rootPage._recid;
            ++this._height;
            dirty = true;
        }
        if (insert._existing == null) {
            ++this._size;
            dirty = true;
        }
        if (dirty) {
            this._cache.update(this._recid, this);
        }
        return insert._existing;
    }

    public static BTree load(RecordManager recman, ObjectCache cache, long recid) throws IOException {
        try {
            BTree btree = (BTree)recman.fetchObject(recid);
            btree._recid = recid;
            btree._recman = recman;
            btree._cache = cache;
            return btree;
        }
        catch (ClassNotFoundException except) {
            throw new Error(except.getMessage());
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._comparator = (Comparator)in.readObject();
        this._height = in.readInt();
        this._root = in.readLong();
        this._pageSize = in.readInt();
        this._size = in.readInt();
    }

    public synchronized Object remove(Object key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        BPage rootPage = this.getRoot();
        if (rootPage == null) {
            return null;
        }
        boolean dirty = false;
        BPage.RemoveResult remove = rootPage.remove(this._height, key);
        if (remove._underflow && rootPage.isEmpty()) {
            --this._height;
            dirty = true;
            this._root = this._height == 0 ? 0L : rootPage.childBPage((int)(this._pageSize - 1))._recid;
        }
        if (remove._value != null) {
            --this._size;
            dirty = true;
        }
        if (dirty) {
            this._cache.update(this._recid, this);
        }
        return remove._value;
    }

    public synchronized int size() {
        return this._size;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._comparator);
        out.writeInt(this._height);
        out.writeLong(this._root);
        out.writeInt(this._pageSize);
        out.writeInt(this._size);
    }

    static class EmptyBrowser
    extends TupleBrowser {
        static TupleBrowser instance = new EmptyBrowser();

        EmptyBrowser() {
        }

        public boolean getNext(Tuple tuple) {
            return false;
        }

        public boolean getPrevious(Tuple tuple) {
            return false;
        }
    }
}

