/*
 * Decompiled with CFR 0.152.
 */
package jdbm.hash;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import jdbm.JDBMEnumeration;
import jdbm.hash.HashBucket;
import jdbm.hash.HashNode;
import jdbm.helper.ObjectCache;
import jdbm.recman.RecordManager;

final class HashDirectory
extends HashNode
implements Externalizable {
    static final long serialVersionUID = 1L;
    static final int MAX_CHILDREN = 256;
    static final int BIT_SIZE = 8;
    static final int MAX_DEPTH = 3;
    private long[] _children;
    private byte _depth;
    private transient RecordManager _recman;
    private transient ObjectCache _cache;
    private transient long _recid;

    public HashDirectory() {
    }

    HashDirectory(byte depth) {
        this._depth = depth;
        this._children = new long[256];
    }

    Object get(Object key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            return null;
        }
        HashNode node = null;
        try {
            node = (HashNode)this._cache.fetchObject(child_recid);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new Error("Unknown class for HashNode");
        }
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, this._cache, child_recid);
            return dir.get(key);
        }
        HashBucket bucket = (HashBucket)node;
        return bucket.getValue(key);
    }

    long getRecid() {
        return this._recid;
    }

    private int hashCode(Object key) {
        int hashMask = this.hashMask();
        int hash = key.hashCode();
        hash &= hashMask;
        hash >>>= (3 - this._depth) * 8;
        return hash %= 256;
    }

    int hashMask() {
        int bits = 255;
        int hashMask = bits << (3 - this._depth) * 8;
        return hashMask;
    }

    boolean isEmpty() {
        int i = 0;
        while (i < this._children.length) {
            if (this._children[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    JDBMEnumeration keys() throws IOException {
        return new HDEnumeration(true);
    }

    Object put(Object key, Object value) throws IOException {
        HashNode node;
        if (value == null) {
            return this.remove(key);
        }
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            long b_recid;
            HashBucket bucket = new HashBucket(this._depth + 1);
            Object existing = bucket.addElement(key, value);
            this._children[hash] = b_recid = this._recman.insert(bucket);
            this._recman.update(this._recid, this);
            return existing;
        }
        try {
            node = (HashNode)this._cache.fetchObject(child_recid);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new Error("Unknown class for HashNode");
        }
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, this._cache, child_recid);
            return dir.put(key, value);
        }
        HashBucket bucket = (HashBucket)node;
        if (bucket.hasRoom()) {
            Object existing = bucket.addElement(key, value);
            this._recman.update(child_recid, bucket);
            return existing;
        }
        if (this._depth == 3) {
            throw new Error("Cannot create deeper directory. Depth=" + this._depth);
        }
        HashDirectory dir = new HashDirectory((byte)(this._depth + 1));
        long dir_recid = this._recman.insert(dir);
        dir.setPersistenceContext(this._recman, this._cache, dir_recid);
        this._children[hash] = dir_recid;
        this._recman.update(this._recid, this);
        this._recman.delete(child_recid);
        Vector keys = bucket.getKeys();
        Vector values = bucket.getValues();
        int entries = keys.size();
        int i = 0;
        while (i < entries) {
            dir.put(keys.elementAt(i), values.elementAt(i));
            ++i;
        }
        return dir.put(key, value);
    }

    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._depth = in.readByte();
        this._children = (long[])in.readObject();
    }

    Object remove(Object key) throws IOException {
        int hash = this.hashCode(key);
        long child_recid = this._children[hash];
        if (child_recid == 0L) {
            return null;
        }
        HashNode node = null;
        try {
            node = (HashNode)this._cache.fetchObject(child_recid);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new Error("Unknown class for HashNode");
        }
        if (node instanceof HashDirectory) {
            HashDirectory dir = (HashDirectory)node;
            dir.setPersistenceContext(this._recman, this._cache, child_recid);
            Object existing = dir.remove(key);
            if (existing != null && dir.isEmpty()) {
                this._recman.delete(child_recid);
                this._children[hash] = 0L;
                this._recman.update(this._recid, this);
            }
            return existing;
        }
        HashBucket bucket = (HashBucket)node;
        Object existing = bucket.removeElement(key);
        if (existing != null) {
            if (bucket.getElementCount() >= 1) {
                this._recman.update(child_recid, bucket);
            } else {
                this._recman.delete(child_recid);
                this._children[hash] = 0L;
                this._recman.update(this._recid, this);
            }
        }
        return existing;
    }

    void setPersistenceContext(RecordManager recman, ObjectCache cache, long recid) {
        this._recman = recman;
        this._cache = cache;
        this._recid = recid;
    }

    JDBMEnumeration values() throws IOException {
        return new HDEnumeration(false);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this._depth);
        out.writeObject(this._children);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class HDEnumeration
    implements JDBMEnumeration {
        private boolean _enumerateKeys;
        private Stack _dirStack = new Stack();
        private Stack _childStack = new Stack();
        private HashDirectory _dir;
        private int _child;
        private Enumeration enum;

        HDEnumeration(boolean enumerateKeys) throws IOException {
            this._dir = HashDirectory.this;
            this._child = -1;
            this._enumerateKeys = enumerateKeys;
            this.prepareNext();
        }

        public synchronized boolean hasMoreElements() throws IOException {
            if (this.enum != null) {
                return this.enum.hasMoreElements();
            }
            return false;
        }

        public synchronized Object nextElement() throws IOException {
            if (this.enum != null) {
                Object next = this.enum.nextElement();
                if (!this.enum.hasMoreElements()) {
                    this.enum = null;
                    this.prepareNext();
                }
                return next;
            }
            throw new IllegalStateException("No more elements");
        }

        private void prepareNext() throws IOException {
            long child_recid = 0L;
            do {
                ++this._child;
                if (this._child >= 256) {
                    if (this._dirStack.isEmpty()) {
                        return;
                    }
                    this._dir = (HashDirectory)this._dirStack.pop();
                    this._child = (Integer)this._childStack.pop();
                    continue;
                }
                child_recid = this._dir._children[this._child];
            } while (child_recid == 0L);
            if (child_recid == 0L) {
                throw new Error("child_recid cannot be 0");
            }
            HashNode node = null;
            try {
                node = (HashNode)HashDirectory.this._cache.fetchObject(child_recid);
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
                throw new Error("Unknown class for HashNode");
            }
            if (node instanceof HashDirectory) {
                this._dirStack.push(this._dir);
                this._childStack.push(new Integer(this._child));
                this._dir = (HashDirectory)node;
                this._child = -1;
                this._dir.setPersistenceContext(HashDirectory.this._recman, HashDirectory.this._cache, child_recid);
                this.prepareNext();
            } else {
                HashBucket bucket = (HashBucket)node;
                this.enum = this._enumerateKeys ? bucket.getKeys().elements() : bucket.getValues().elements();
            }
        }
    }
}

