/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.UnsupportedEncodingException;

public class Conversion {
    public static byte[] convert(byte n) {
        n = (byte)(n ^ 0xFFFFFF80);
        return new byte[]{n};
    }

    public static byte[] convert(int n) {
        byte[] key = new byte[4];
        Conversion.pack4(key, 0, n ^= Integer.MIN_VALUE);
        return key;
    }

    public static byte[] convert(long n) {
        byte[] key = new byte[8];
        Conversion.pack8(key, 0, n ^= Long.MIN_VALUE);
        return key;
    }

    public static byte[] convert(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new Error("Platform doesn't support UTF8 encoding");
        }
    }

    public static byte[] convert(short n) {
        n = (short)(n ^ Short.MIN_VALUE);
        byte[] key = new byte[2];
        Conversion.pack2(key, 0, n);
        return key;
    }

    static final void pack2(byte[] data, int offs, int val) {
        data[offs++] = (byte)(val >> 8);
        data[offs++] = (byte)val;
    }

    static final void pack4(byte[] data, int offs, int val) {
        data[offs++] = (byte)(val >> 24);
        data[offs++] = (byte)(val >> 16);
        data[offs++] = (byte)(val >> 8);
        data[offs++] = (byte)val;
    }

    static final void pack8(byte[] data, int offs, long val) {
        Conversion.pack4(data, 0, (int)(val >> 32));
        Conversion.pack4(data, 4, (int)val);
    }
}

