/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import jdbm.recman.Location;
import jdbm.recman.LogicalRowIdManager;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowIdManager;
import jdbm.recman.RecordCache;
import jdbm.recman.RecordFile;

public final class RecordManager {
    private RecordFile file;
    private PhysicalRowIdManager physMgr;
    private LogicalRowIdManager logMgr;
    private PageManager pageman;
    private Vector caches = new Vector();
    public static final int NAME_DIRECTORY_ROOT = 0;
    private Hashtable nameDirectory;

    public RecordManager(String filename) throws IOException {
        this.file = new RecordFile(filename);
        this.pageman = new PageManager(this.file);
        this.physMgr = new PhysicalRowIdManager(this.file, this.pageman);
        this.logMgr = new LogicalRowIdManager(this.file, this.pageman);
    }

    public synchronized void addCache(RecordCache cache) {
        if (!this.caches.contains(cache)) {
            this.caches.addElement(cache);
        }
    }

    private static Object byteArrayToObject(byte[] array) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    public synchronized void close() throws IOException {
        int i = 0;
        while (i < this.caches.size()) {
            ((RecordCache)this.caches.elementAt(i)).flushAll();
            ((RecordCache)this.caches.elementAt(i)).invalidateAll();
            ++i;
        }
        this.pageman.close();
        this.pageman = null;
        this.file.close();
        this.file = null;
    }

    public synchronized void commit() throws IOException {
        int i = 0;
        while (i < this.caches.size()) {
            ((RecordCache)this.caches.elementAt(i)).flushAll();
            ++i;
        }
        this.pageman.commit();
    }

    public synchronized void delete(long recid) throws IOException {
        int i = 0;
        while (i < this.caches.size()) {
            ((RecordCache)this.caches.elementAt(i)).invalidate(recid);
            ++i;
        }
        Location logRowId = new Location(recid);
        Location physRowId = this.logMgr.fetch(logRowId);
        this.physMgr.delete(physRowId);
        this.logMgr.delete(logRowId);
    }

    public synchronized void disableTransactions() {
        this.file.disableTransactions();
    }

    public synchronized byte[] fetchByteArray(long recid) throws IOException {
        int i = 0;
        while (i < this.caches.size()) {
            ((RecordCache)this.caches.elementAt(i)).flush(recid);
            ++i;
        }
        return this.physMgr.fetch(this.logMgr.fetch(new Location(recid)));
    }

    public synchronized Object fetchObject(long recid) throws IOException, ClassNotFoundException {
        int i = 0;
        while (i < this.caches.size()) {
            ((RecordCache)this.caches.elementAt(i)).flush(recid);
            ++i;
        }
        byte[] buffer = this.physMgr.fetch(this.logMgr.fetch(new Location(recid)));
        return RecordManager.byteArrayToObject(buffer);
    }

    private Hashtable getNameDirectory() throws IOException {
        long nameDirectory_recid = this.getRoot(0);
        if (nameDirectory_recid == 0L) {
            this.nameDirectory = new Hashtable();
            nameDirectory_recid = this.insert(this.nameDirectory);
            this.setRoot(0, nameDirectory_recid);
        } else {
            try {
                this.nameDirectory = (Hashtable)this.fetchObject(nameDirectory_recid);
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
                throw new Error("NAME_DIRECTORY_ROOT must point to a Hashtable");
            }
        }
        return this.nameDirectory;
    }

    public synchronized long getNamedObject(String name) throws IOException {
        Hashtable nameDirectory = this.getNameDirectory();
        Long recid = (Long)nameDirectory.get(name);
        if (recid == null) {
            return 0L;
        }
        return recid;
    }

    public synchronized long getRoot(int id) throws IOException {
        return this.pageman.getFileHeader().getRoot(id);
    }

    public int getRootCount() {
        return 1013;
    }

    public long insert(Object obj) throws IOException {
        byte[] buffer = RecordManager.objectToByteArray(obj);
        return this.insert(buffer);
    }

    public synchronized long insert(byte[] data) throws IOException {
        Location physRowId = this.physMgr.insert(data);
        return this.logMgr.insert(physRowId).toLong();
    }

    private static byte[] objectToByteArray(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        baos.close();
        return baos.toByteArray();
    }

    public synchronized void removeCache(RecordCache cache) {
        this.caches.removeElement(cache);
    }

    public synchronized void rollback() throws IOException {
        int i = 0;
        while (i < this.caches.size()) {
            ((RecordCache)this.caches.elementAt(i)).invalidateAll();
            ++i;
        }
        this.pageman.rollback();
    }

    private void saveNameDirectory(Hashtable directory) throws IOException {
        long recid = this.getRoot(0);
        if (recid == 0L) {
            throw new Error("Name directory must exist");
        }
        this.update(recid, this.nameDirectory);
    }

    public synchronized void setNamedObject(String name, long recid) throws IOException {
        Hashtable nameDirectory = this.getNameDirectory();
        if (recid == 0L) {
            nameDirectory.remove(name);
        } else {
            nameDirectory.put(name, new Long(recid));
        }
        this.saveNameDirectory(nameDirectory);
    }

    public synchronized void setRoot(int id, long rowid) throws IOException {
        this.pageman.getFileHeader().setRoot(id, rowid);
    }

    public void update(long recid, Object obj) throws IOException {
        byte[] buffer = RecordManager.objectToByteArray(obj);
        this.update(recid, buffer);
    }

    public synchronized void update(long recid, byte[] data) throws IOException {
        int i = 0;
        while (i < this.caches.size()) {
            ((RecordCache)this.caches.elementAt(i)).invalidate(recid);
            ++i;
        }
        Location logRecid = new Location(recid);
        Location physRecid = this.logMgr.fetch(logRecid);
        Location newRecid = this.physMgr.update(physRecid, data);
        if (!newRecid.equals(physRecid)) {
            this.logMgr.update(logRecid, newRecid);
        }
    }
}

