/*
 * FullTextSearchApplicationPack
 * SAvP[ṼR\[
 */
package org.logical_paradox.fts;

import javax.swing.JTextField;

import org.logical_paradox.console.ApplicationPack;

public final class FullTextSearchApplicationPack extends ApplicationPack {
	private SearchCore core;

	public FullTextSearchApplicationPack() {
		super();
		try {
			init();
		} catch(Exception e) {}
	}
	// AvP[V
	public void init() throws Exception {
		String factoryClassName = System.getProperty( FullTextSearchProperty.FTS_INDEX_ACCESSOR_FACTORY_PROPERTY );
		if( factoryClassName == null || factoryClassName.length() == 0 ) {
			// vpeBw肳ĂȂꍇCftHglgp
			factoryClassName = FullTextSearchProperty.FTS_INDEX_ACCESSOR_FACTORY_NAME;
		}

		IndexAccessorFactory factory = (IndexAccessorFactory)Class.forName(factoryClassName).newInstance();
		core = new SearchCore(factory.getIndexAccessor(FullTextSearchProperty.FTS_INDEX_PROPERTY_NAME));
	}
	// eLXgtB[hɉ͂ꂽꍇ̃Cxg
	public void cbTextField( JTextField jtf ) throws Exception {
		String[] searchWords = jtf.getText().trim().split( " " );		// pXy[X؂Ō𕪊
		SearchResult[] results = core.search( searchWords );
		jtf.setText( "" );

		cleanLogView();

		if( results != null ) {
			getWriter().println( "Y: " + results.length );
			for( int i = 0; i < results.length; i++ ) {
				getWriter().println( "(" + i + "): " + results[i].pos[0]._pos );
				getWriter().println( "------------------------------" );		// s
				getWriter().println( results[i].result );
				getWriter().println( "------------------------------" );		// s
			}
		} else {
			getWriter().println( "v܂ł" );
		}
	}
	// AvP[VI
	public void destroy() throws Exception {
		if( core != null ) {
			core.close();
			core = null;
		}
	}
}

// end of FullTextSearchApplicationPack.java