/*
 * Parser
 */
package org.logical_paradox.fts;

import java.util.HashMap;


public class Parser {
	public final int gramLength;
	private final IndexAccessor accessor;

	// RXgN^
	public Parser( IndexAccessor axsr, int length ) {
		accessor = axsr;
		gramLength = length;
	}

	// p[U[
	public void parse( String txt, int dicno ) throws ParserException, IndexAccessException {
		int loopCnt = txt.length() - gramLength;
		if( loopCnt < 0 ) {
			throw new ParserException( "^ꂽ̒ɑ΂N-gram傫܂" );
		}

		HashMap cache = new HashMap();
		
		for( int cnt = 0; cnt < txt.length(); cnt++ ) {									// C v1.1 2003-12-13
			int tokenLength = gramLength - ((cnt-loopCnt) <= 0 ? 0 : cnt-loopCnt);			// C v1.1 2003-12-13
			String token = txt.substring( cnt, cnt + tokenLength );							// C v1.1 2003-12-13
			if( token.length() < gramLength ) {
				System.err.println( token.length() + ":" + token );
			}

			Key key = new InvertedIndexKey( token );

			// LbVĂȂ̂ŁCANZT擾
			KeywordLocationArray pos = (KeywordLocationArray)cache.get(key);

			if(pos == null) {
				// LbVɑ݂ȂꍇCt@C擾Ă݂
				pos = (KeywordLocationArray)accessor.getValue(key);
				if(pos == null) {
					// t@Cɂ瑶݂ȂꍇCV̈쐬
					pos = new KeywordLocationArray();
				}
			}

			pos.add(new KeywordLocation(dicno, cnt));
			cache.put(key, pos);
			accessor.addKey(key, pos);
		}
	}
}

// end of Parser.java
