/*
 * SearchCore
 * VXẽRA̕
 * ͂ꂽCfbNX猟āCYzɂĕԂ
 */
package org.logical_paradox.fts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SearchCore {
	protected final IndexAccessor accessor;

	// RXgN^
	public SearchCore( IndexAccessor axsr ) {
		accessor = axsr;
	}

	// w肳ꂽNG[ɑΉL[擾
	private IndexFoundLocation getKey(String query) throws IndexAccessException {
		InvertedIndexKey key = new InvertedIndexKey(query);
		KeywordLocationArray locations = (KeywordLocationArray)accessor.getValue(key);
		if( locations == null ) {
			System.out.println("w肳ꂽ́CɂȂ:" + query);
			return null;
		}

		for(Iterator it = locations.iterator(); it.hasNext();) {
			key.setIndexTermOnDocument(((KeywordLocation)it.next())._dicno, true );
		}
// TODO fobO\
System.out.println("key=" + key.toString() + "," + key.get64bitFormat(key.document));
		// L[ƁC̏oʒuԂ
		return new IndexFoundLocation(key, locations.toArray());
	}

	// w肳ꂽNG[ɊÂʂzŕԂ
	// version 1.0ł́CNG[͌ƂCANDƂ
	public SearchResult[] search( String[] searchWords ) throws IndexAccessException {
		long founddic = -1;
		IndexFoundLocation[][] indexFoundLocations = new IndexFoundLocation[searchWords.length][];
		Vector result = new Vector();

		try {
			// SĂ̍ꂪ݂镶ԍ܂ŏɊo
			for( int cnt = 0; cnt < searchWords.length; cnt++ ) {						// A v1.1 2003-12-13
				String[] queries = parseQuery( new String( searchWords[cnt].trim().getBytes(), "Shift_JIS" ) );		// Unicodeɕϊď

				indexFoundLocations[cnt] = new IndexFoundLocation[queries.length];
				for( int i = 0; i < queries.length; i++ ) {
					IndexFoundLocation foundLocation = getKey( queries[i] );
					if( foundLocation != null ) {
						founddic &= foundLocation.key.getDocument();					// AND鏊
						indexFoundLocations[cnt][i] = foundLocation;
					} else {
						founddic = 0;									// w肳ꂽNG[ōꂪłȂ̂ŁCYȂ(ANDȂ̂)
					}
				}

				if( founddic == 0L ) {
					// 1qbgȂꍇ
					return null;
				}

				// ʂWv
				// ̒iKŁCfounddicɂ͑SĂ݂(Ȃ)ԍi[Ă
				// ꂪAĂ΁CƂ݂Ȃ
				ParsedKeyLocation pk = parseKeyLocations( indexFoundLocations[cnt], founddic );		// C v1.1 2003-12-13
				founddic &= pk.docno;																// A v1.1 2003-12-13
				if( pk.isEmpty() == false ) {
					result.addElement( pk );
				}
			}

			// w肳ꂽ̐ƁCWJꂽʒu̐vĂȂ΁D
			// 炩̌ꂪɑ݂ȂƂɂȂD
			if( result == null || result.size() != searchWords.length ) {
				return null;
			}

			// T}[쐬
			return getSummary( (ParsedKeyLocation[])result.toArray( new ParsedKeyLocation[0] ), founddic );
		} catch( Exception uee ) {
			uee.printStackTrace();
			throw new IndexAccessException( uee.getMessage() );
		}
	}

	// ʒu񂩂T}[쐬āCʂƂĕԂ
	// locations[] - ʒu
	// founddic - ꂪʂđ݂Ă镶ԍ
	protected SearchResult[] getSummary( ParsedKeyLocation[] locations, long founddic ) {
		// ܂C^ꂽ̍\Ɉɂ̂ŁCύX
		// locationsPerSummary[no.] = { ʒu1, ʒu2, .. ʒun }
		// Ƃ\ɂDʒúC̎ނɊ֌WȂCoʒuԂɊi[X^CƂD
		InvertedIndexKey ik = new InvertedIndexKey( "", founddic );
		Map locationsPerSummary = new HashMap();
		for( int i = 0; i < locations.length; i++ ) {
			KeywordLocation[] kl = (KeywordLocation[])locations[i].getLocations();
			for( int j = 0; j < kl.length; j++ ) {
//System.err.println( "docno=" + kl[j]._dicno + ", pos=" + kl[j]._pos );
				if( ik.isTermFoundInDocument( kl[j]._dicno ) == false ) {
					continue;
				}
//System.err.println( "docno=" + kl[j]._dicno + ", pos=" + kl[j]._pos );
				Vector v = (Vector)locationsPerSummary.get(new Integer( kl[j]._dicno ));
				if( v == null ) {
					v = new Vector();
				}
				v.addElement( kl[j] );
				locationsPerSummary.put( new Integer( kl[j]._dicno ), v );
			}
		}

		Iterator it = locationsPerSummary.keySet().iterator();
		SearchResult[] rcs = new SearchResult[ locationsPerSummary.size() ];
		int rcsc = 0;
		Integer intg = null;
		Vector vref = null;
		String rcstr = null;
		KeywordLocation[] lo = null;

		while( it.hasNext() ) {
			intg = (Integer)it.next();
			if( intg != null && (vref = (Vector)locationsPerSummary.get( intg )) != null ) {
				Collections.sort( vref, KeywordLocationComparator.getComparator() );
				lo = (KeywordLocation[])vref.toArray( new KeywordLocation[0] );
				rcstr = getSummaryByLocations( lo );
				rcs[rcsc++] = new SearchResult( lo, rcstr.toString() );
			}
		}

		return rcs;
	}

	// ʒu񂩂T}[؂oĕԂ
	protected String getSummaryByLocations( KeywordLocation[] lo ) {
		int highScore = 0;
		int lastCnt = 0;
		int lengthOfSummary = 100;
		int basep = 0;
		int score = 1;							// ȂƂ1͔͈͓Ɋ܂܂Ă͂

		for( int i = 0; i < lo.length; i++ ) {
			basep = lo[i]._pos;					// _̎擾
			score = score <= 1 ? 1 : (score-1);
			for( int j = score; j < lo.length; j++ ) {
				if( basep + lengthOfSummary > lo[j]._pos ) {
					score++;
				}
			}
			if( highScore < score ) {
				// nCXRAXV
				highScore = score;
				lastCnt = i;
			}
		}

		try {
			String filename = "db" + File.separator + (lo[0]._dicno+1);
			String document = getDocument( filename );
			int lastp = 0;
			if( document.length() <= lengthOfSummary + lo[lastCnt]._pos ) {
				lastp = document.length()-1;
			} else {
				lastp = lo[lastCnt]._pos + lengthOfSummary -1;
			}

			String summary = document.substring( lo[lastCnt]._pos, lastp );
			return summary;
		} catch( IOException ioe ) {
			ioe.printStackTrace();
			return "";
		}
	}

	// f[^ǂݍ
	protected String getDocument( String filename ) throws IOException {
		try {
			BufferedReader br = new BufferedReader( new InputStreamReader( new FileInputStream( filename ), "UnicodeBig" ) );
			StringBuffer sb = new StringBuffer();
			String line = null;

			while( (line = br.readLine()) != null ) {
				sb.append( line );
			}
			br.close();

			return sb.toString();
		} catch( Exception e ) {
			throw new IOException( e.getMessage() );
		}
	}

	// ʂ͂
	protected ParsedKeyLocation parseKeyLocations( IndexFoundLocation[] indexFoundLocations, long founddic ) {
		InvertedIndexKey dicKey = new InvertedIndexKey( "", founddic );
		InvertedIndexKey foundKey = new InvertedIndexKey( "" );

		// ̂܂܂ƘAmFƂɂ̂ŁC\ύX
		// hashtable[No.][ꂪꂽ̈ʒu(擪̃ItZbg)] = 
		// Ƃ\ɂD
		Hashtable dics = new Hashtable();
		for( int i = 0; i < indexFoundLocations.length; i++ ) {
			KeywordLocation[] locations = indexFoundLocations[i].locations;
			for( int j = 0; j < locations.length; j++ ) {
				Hashtable locationsOfDic = (Hashtable)dics.get( new Integer(locations[j]._dicno) );
				if( locationsOfDic == null ) {
					locationsOfDic = new Hashtable();
				}
				locationsOfDic.put( new Integer(locations[j]._pos), indexFoundLocations[i].key.getKey() );
				dics.put( new Integer(locations[j]._dicno), locationsOfDic );
			}
		}

		// L[1Ԗڂ̔[v
		int terms = indexFoundLocations.length -1;		// AĔzuĂȂ΂ȂȂ̐(ŏ1͊ɂȂ̂ŏO)
		ParsedKeyLocation pk = new ParsedKeyLocation();		// A v1.2 2003-12-23

		for( int pos = 0; pos < indexFoundLocations[0].locations.length; pos++ ) {
			if( dicKey.isTermFoundInDocument( indexFoundLocations[0].locations[pos]._dicno ) == false ) {
				// w肳ꂽL[o^Ă镶ΏۊȌꍇ͖
				continue;
			}

			// 1Ԗڂ̍ꂪꂽʒu肷
			int termOffset = indexFoundLocations[0].locations[pos]._pos;		// oʒu
			int termDocNo = indexFoundLocations[0].locations[pos]._dicno;		// No.
			Hashtable docset = (Hashtable)dics.get( new Integer( termDocNo ) );	// w肳ꂽNo.ɑΉʒuZbg擾
			if( docset == null ) {
				// ZbgɎw肳ꂽNo.̈ʒu񂪂Ȃꍇ͎
				continue;
			}

			// ꂪAĂ邩ǂ𒲂ׂ
			// [v1JnD0͍ŏ̍Ȃ̂ŁCAmFɂ͕KvȂ
			boolean rc = true;
			for( int k = 1; k < terms; k++ ) {
				String term = (String)docset.get( new Integer( termOffset + k ) );		// 1Ԗڂ̍ꂩ琔kԖڂ̍擾
// System.err.println( "termDocNo=" + termDocNo + " offset=" + termOffset + " k=" + k + ":" + term );
				if( term == null || term.equals( indexFoundLocations[k].key.getKey() ) == false ) {
					// ꂪAĂȂ̂ŋI
					rc = false;
					break;
				}
			}

			if( rc == true ) {
				// SĂ̍ꂪAĔzuĂꍇ
				// ŏ̍ꂪꂽNo.ƈʒuۑ
				pk.add( new KeywordLocation(termDocNo,termOffset) );
				foundKey.setIndexTermOnDocument(termDocNo, true); 
			}
		}

		pk.docno = foundKey.getDocument();
		return pk;
	}

	protected String[] parseQuery( String txt ) {
		int loopCnt = txt.length() - FullTextSearchProperty.GRAM_LENGTH +1;		// C v1.1 2003-12-13
		//----- A v1.1 2003-12-13 bgn
		int gramLength = FullTextSearchProperty.GRAM_LENGTH;
		if( loopCnt <= 0 ) {
			gramLength += (loopCnt-1);
			loopCnt = 1;			// 񂪎w肳ꂽꍇCK1͍ɂȂ
		}
		//----- A v1.1 2003-12-13 end
		String[] terms = new String[ loopCnt ];
		for( int cnt = 0; cnt < loopCnt; cnt++ ) {
			terms[cnt] = txt.substring( cnt, cnt + gramLength );		// C v1.1 2003-12-13
		}

		return terms;
	}


	// T[`RA
	public void close() throws IndexAccessException {
		if( accessor.isClosed() == false ) {
			accessor.close();
		}
	}

	class ParsedKeyLocation {
		private final Hashtable locations;
		public long docno;

		public ParsedKeyLocation() {
			docno = 0;
			locations = new Hashtable();
		}
		public boolean isEmpty() {
			return locations.isEmpty();
		}
		public void add( KeywordLocation lo ) {
			Integer dn = new Integer( lo._dicno );
			Vector locationsInDocument = (Vector)locations.get(dn);
			if( locationsInDocument == null ) {
				locationsInDocument = new Vector();
			}
			locationsInDocument.addElement( lo );
			locations.put( dn, locationsInDocument );
		}
		public void add( KeywordLocation[] lo ) {
			for( int i = 0; i < lo.length; i++ ) {
				add( lo[i] );
			}
		}
		public KeywordLocation[] getLocations() {
			Iterator it = locations.keySet().iterator();
			Vector v = new Vector();
			Vector lo = null;

			while( it.hasNext() ) {
				Integer dn = (Integer)it.next();
				if( dn == null ) {
					continue;
				}
				if( dn != null && (lo = (Vector)locations.get(dn)) != null ) {
					v.addAll( lo );
				}
			}

			return (KeywordLocation[])v.toArray( new KeywordLocation[0] );
		}
		public KeywordLocation[] get( int dn ) {
			Vector locationsInDocument = (Vector)locations.get( new Integer( dn ) );
			if( locationsInDocument == null ) {
				return new KeywordLocation[0];
			} else {
				return (KeywordLocation[])locationsInDocument.toArray( new KeywordLocation[0] );
			}
		}
	}

	class IndexFoundLocation {
		public final InvertedIndexKey key;
		public final KeywordLocation[] locations;

		public IndexFoundLocation( InvertedIndexKey k, KeywordLocation[] l ) {
			key = k;
			locations = l;
		}
	}
}

// end of SearchCore.java
