/*
 * InvertedIndexKeyTest
 * InvertedIndexKeyNX̃eXgP[X
 */
package org.logical_paradox.fts;

import junit.framework.TestCase;

public class InvertedIndexKeyTest extends TestCase {
	public InvertedIndexKeyTest( String name ) {
		super( name );
	}

	// ñeXg(Zbg)
	public void testInvertedIndexKeySuccess1() throws Exception {
		for( int i = 0; i < 63; i++ ) {
			InvertedIndexKey idxr = new InvertedIndexKey("");
			idxr.setIndexTermOnDocument( i, true );
			assertTrue( "Zbg[" + i + "]", idxr.isTermFoundInDocument( i ) == true );
		}
	}
	public void testInvertedIndexKeySuccess2() throws Exception {
		for( int i = 0; i < 63; i++ ) {
			InvertedIndexKey idxr = new InvertedIndexKey("");
			idxr.setIndexTermOnDocument( i, true );
			idxr.setIndexTermOnDocument( i, false );
			assertTrue( "Zbg[" + i + "]", idxr.isTermFoundInDocument( i ) == false );
		}
	}

	// QñeXg
	public void testInvertedIndexKeyFail1() throws Exception {
		// A_[t[eXg
		try {
			InvertedIndexKey idxr = new InvertedIndexKey("");
			idxr.setIndexTermOnDocument(-1, true);
			fail( "A_[t[eXgŐO܂ł" );
		} catch( IllegalArgumentException e1 ) {
			// Ô̂ŁCȂ
		}

		// I[o[t[eXg
		try {
			InvertedIndexKey idxr = new InvertedIndexKey("");
			idxr.setIndexTermOnDocument(64, true);
			fail( "I[o[t[eXgŐO܂ł" );
		} catch( IllegalArgumentException e2 ) {
			// Ô̂ŁCȂ
		}
	}
	public void testInvertedIndexKeyFail2() throws Exception {
		// A_[t[eXg
		try {
			InvertedIndexKey idxr = new InvertedIndexKey("");
			idxr.setIndexTermOnDocument(-1, false);
			fail( "A_[t[eXgŐO܂ł" );
		} catch( IllegalArgumentException e1 ) {
			// Ô̂ŁCȂ
		}

		// I[o[t[eXg
		try {
			InvertedIndexKey idxr = new InvertedIndexKey("");
			idxr.setIndexTermOnDocument(64, false);
			fail( "I[o[t[eXgŐO܂ł" );
		} catch( IllegalArgumentException e2 ) {
			// Ô̂ŁCȂ
		}
	}
}

// end of InvertedIndexKeyTest.java
