/*
 * IndexFileConfirmTool
 * CfbNXt@C̓emFc[
 */
package org.logical_paradox.fts.testtools;

import java.util.*;

import jdbm.*;
import org.logical_paradox.fts.*;

public class IndexFileConfirmTool {
	public static void main( String args[] ) throws Exception {
		JDBMRecordManager jdbm = new JDBMRecordManager( "fts.idx" );
		JDBMHashtable table = jdbm.getHashtable( "FTS_INDEX_TBL" );

		JDBMEnumeration e = table.keys();
		Vector v = new Vector();
		while( e.hasMoreElements() ) {
			Key k = (Key)e.nextElement();
			v.addElement( k );
		}

		for( int i = 0; i < v.size(); i++ ) {
			Key k = (Key)v.elementAt(i);
			String decodedKey = new String( k.getKey().getBytes(), "Shift_JIS" );
			System.out.print( decodedKey + "(" );
			KeywordLocation[] pos = (KeywordLocation[])table.get(k);
			if( pos == null ) {
				System.out.println( "Ȃ" );
			} else {
				for( int cnt = 0; cnt < pos.length; cnt++ ) {
					if( cnt > 0 ) {
						System.out.print( "," );
					}
					System.out.print( pos[cnt] );
				}
			}
			System.out.println( ")" );
		}

		jdbm.close();
	}
}

// end of IndexFileConfirmTool.java
