/*
 * Decompiled with CFR 0.152.
 */
package jdbm;

import java.io.IOException;
import jdbm.JDBMEnumeration;
import jdbm.JDBMHashtable;
import jdbm.hash.HTree;
import jdbm.helper.ObjectCache;
import jdbm.recman.RecordManager;

class HTreeWrapper
implements JDBMHashtable {
    private RecordManager _recman;
    private HTree _tree;

    HTreeWrapper(RecordManager recman, ObjectCache cache, long root_recid) throws IOException {
        this._recman = recman;
        this._tree = HTree.load(recman, cache, root_recid);
    }

    public void dispose() throws IOException {
        this._tree.dispose();
        this._tree = null;
        this._recman = null;
    }

    public Object get(Object key) throws IOException {
        Object obj = this._tree.get(key);
        this._recman.commit();
        return obj;
    }

    public long getRecid() {
        return this._tree.getRecid();
    }

    public JDBMEnumeration keys() throws IOException {
        return this._tree.keys();
    }

    public void put(Object key, Object value) throws IOException {
        this._tree.put(key, value);
        this._recman.commit();
    }

    public void remove(Object key) throws IOException {
        this._tree.remove(key);
        this._recman.commit();
    }

    public JDBMEnumeration values() throws IOException {
        return this._tree.values();
    }
}

