/*
 * Decompiled with CFR 0.152.
 */
package jdbm.hash;

import java.io.IOException;
import jdbm.JDBMEnumeration;
import jdbm.JDBMHashtable;
import jdbm.hash.HashDirectory;
import jdbm.helper.ObjectCache;
import jdbm.recman.RecordManager;

public class HTree
implements JDBMHashtable {
    private HashDirectory _root;

    private HTree(HashDirectory root) {
        this._root = root;
    }

    public HTree(RecordManager recman, ObjectCache cache) throws IOException {
        this._root = new HashDirectory(0);
        long recid = recman.insert(this._root);
        this._root.setPersistenceContext(recman, cache, recid);
    }

    public synchronized void dispose() throws IOException {
        this._root = null;
    }

    public synchronized Object get(Object key) throws IOException {
        return this._root.get(key);
    }

    public long getRecid() {
        return this._root.getRecid();
    }

    public synchronized JDBMEnumeration keys() throws IOException {
        return this._root.keys();
    }

    public static HTree load(RecordManager recman, ObjectCache cache, long root_recid) throws IOException {
        try {
            HashDirectory root = (HashDirectory)recman.fetchObject(root_recid);
            root.setPersistenceContext(recman, cache, root_recid);
            HTree tree = new HTree(root);
            return tree;
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            throw new Error("Hashtable root object must be HashDirectory");
        }
    }

    public synchronized void put(Object key, Object value) throws IOException {
        this._root.put(key, value);
    }

    public synchronized void remove(Object key) throws IOException {
        this._root.remove(key);
    }

    public synchronized JDBMEnumeration values() throws IOException {
        return this._root.values();
    }
}

