/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jdbm.helper.CacheEntry;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.MRUEnumeration;

public class MRU
implements CachePolicy {
    Hashtable _hash = new Hashtable();
    int _max;
    CacheEntry _first;
    CacheEntry _last;
    Vector listeners = new Vector();

    public MRU(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("MRU cache must contain at least one entry");
        }
        this._max = max;
    }

    protected void addEntry(CacheEntry entry) {
        if (this._first == null) {
            this._first = entry;
            this._last = entry;
        } else {
            this._last.setNext(entry);
            entry.setPrevious(this._last);
            this._last = entry;
        }
    }

    public void addListener(CachePolicyListener listener) {
        this.listeners.addElement(listener);
    }

    public Enumeration elements() {
        return new MRUEnumeration(this._hash.elements());
    }

    public Object get(Object key) {
        CacheEntry entry = (CacheEntry)this._hash.get(key);
        if (entry != null) {
            this.touchEntry(entry);
            return entry.getValue();
        }
        return null;
    }

    protected CacheEntry purgeEntry() throws CacheEvictionException {
        CacheEntry entry = this._first;
        this.removeEntry(entry);
        this._hash.remove(entry.getKey());
        int i = 0;
        while (i < this.listeners.size()) {
            CachePolicyListener listener = (CachePolicyListener)this.listeners.elementAt(i);
            listener.cacheObjectEvicted(entry.getValue());
            ++i;
        }
        entry.setValue(null);
        return entry;
    }

    public void put(Object key, Object value) throws CacheEvictionException {
        CacheEntry entry = (CacheEntry)this._hash.get(key);
        if (entry != null) {
            entry.setValue(value);
            this.touchEntry(entry);
        } else {
            if (this._hash.size() == this._max) {
                entry = this.purgeEntry();
                entry.setKey(key);
                entry.setValue(value);
            } else {
                entry = new CacheEntry(key, value);
            }
            this.addEntry(entry);
            this._hash.put(entry.getKey(), entry);
        }
    }

    public void remove(Object key) {
        CacheEntry entry = (CacheEntry)this._hash.get(key);
        if (entry != null) {
            this.removeEntry(entry);
            this._hash.remove(entry.getKey());
        }
    }

    public void removeAll() {
        this._hash = new Hashtable();
        this._first = null;
        this._last = null;
    }

    protected void removeEntry(CacheEntry entry) {
        if (entry == this._first) {
            this._first = entry.getNext();
        }
        if (this._last == entry) {
            this._last = entry.getPrevious();
        }
        CacheEntry previous = entry.getPrevious();
        CacheEntry next = entry.getNext();
        if (previous != null) {
            previous.setNext(next);
        }
        if (next != null) {
            next.setPrevious(previous);
        }
        entry.setPrevious(null);
        entry.setNext(null);
    }

    public void removeListener(CachePolicyListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void touchEntry(CacheEntry entry) {
        if (this._last == entry) {
            return;
        }
        this.removeEntry(entry);
        this.addEntry(entry);
    }
}

