/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import jdbm.recman.BlockIo;
import jdbm.recman.BlockView;

class FileHeader
implements BlockView {
    private static final short O_MAGIC = 0;
    private static final short O_LISTS = 2;
    private static final int O_ROOTS = 82;
    private BlockIo block;
    static final int NROOTS = 1013;

    FileHeader(BlockIo block, boolean isNew) {
        this.block = block;
        if (isNew) {
            block.writeShort(0, (short)4944);
        } else if (!this.magicOk()) {
            throw new Error("CRITICAL: file header magic not OK " + block.readShort(0));
        }
    }

    long getFirstOf(int list) {
        return this.block.readLong(this.offsetOfFirst(list));
    }

    long getLastOf(int list) {
        return this.block.readLong(this.offsetOfLast(list));
    }

    long getRoot(int root) {
        return this.block.readLong(this.offsetOfRoot(root));
    }

    private boolean magicOk() {
        return this.block.readShort(0) == 4944;
    }

    private short offsetOfFirst(int list) {
        return (short)(2 + 16 * list);
    }

    private short offsetOfLast(int list) {
        return (short)(this.offsetOfFirst(list) + 8);
    }

    private short offsetOfRoot(int root) {
        return (short)(82 + root * 8);
    }

    void setFirstOf(int list, long value) {
        this.block.writeLong(this.offsetOfFirst(list), value);
    }

    void setLastOf(int list, long value) {
        this.block.writeLong(this.offsetOfLast(list), value);
    }

    void setRoot(int root, long rowid) {
        this.block.writeLong(this.offsetOfRoot(root), rowid);
    }
}

