/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FreePhysicalRowId;
import jdbm.recman.FreePhysicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;

final class FreePhysicalRowIdPageManager {
    RecordFile file;
    PageManager pageman;

    FreePhysicalRowIdPageManager(RecordFile file, PageManager pageman) throws IOException {
        this.file = file;
        this.pageman = pageman;
    }

    Location get(int size) throws IOException {
        Location retval = null;
        PageCursor curs = new PageCursor(this.pageman, 4);
        while (curs.next() != 0L) {
            FreePhysicalRowIdPage fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(this.file.get(curs.getCurrent()));
            int slot = fp.getFirstLargerThan(size);
            if (slot != -1) {
                retval = new Location(fp.get(slot));
                int slotsize = fp.get(slot).getSize();
                fp.free(slot);
                if (fp.getCount() == 0) {
                    this.file.release(curs.getCurrent(), false);
                    this.pageman.free((short)4, curs.getCurrent());
                } else {
                    this.file.release(curs.getCurrent(), true);
                }
                return retval;
            }
            this.file.release(curs.getCurrent(), false);
        }
        return null;
    }

    void put(Location rowid, int size) throws IOException {
        FreePhysicalRowIdPage fp;
        BlockIo curBlock;
        PhysicalRowId free = null;
        PageCursor curs = new PageCursor(this.pageman, 4);
        long freePage = 0L;
        while (curs.next() != 0L) {
            freePage = curs.getCurrent();
            curBlock = this.file.get(freePage);
            fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(curBlock);
            int slot = fp.getFirstFree();
            if (slot != -1) {
                free = fp.alloc(slot);
                break;
            }
            this.file.release(curBlock);
        }
        if (free == null) {
            freePage = this.pageman.allocate((short)4);
            curBlock = this.file.get(freePage);
            fp = FreePhysicalRowIdPage.getFreePhysicalRowIdPageView(curBlock);
            free = fp.alloc(0);
        }
        free.setBlock(rowid.getBlock());
        free.setOffset(rowid.getOffset());
        ((FreePhysicalRowId)free).setSize(size);
        this.file.release(freePage, true);
    }
}

