/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.lang;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.logical_paradox.common.io.ByteStream;

public class LongByteStream
implements ByteStream {
    private final Long value;
    private final byte[] bstream;

    public LongByteStream(Long l) {
        this.value = l;
        this.bstream = this.objectToByteStream(l);
    }

    public LongByteStream(long l) {
        this(new Long(l));
    }

    public Long getLongObject() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public byte[] byteStream() {
        return this.bstream;
    }

    protected byte[] objectToByteStream(long l) {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        ((Buffer)buffer).rewind();
        buffer.putLong(l);
        return buffer.array();
    }
}

